

function readStoreInt(key) {
	var v = readStore(key);
	if(typeof(v)=="number") return v*1;
	if(typeof(v)=="string" && v!='') return parseInt(v);
	else return 0;
}
function readStore(key) {
	var val = $.jStorage.get(key)
	if(typeof(val) == 'undefined' || val===null) val = "";
	return val;	
}
function writeStore(keyinput, valinput) {
	$.jStorage.set(keyinput, valinput)
	return;
}


var FELD;
var WORTE;
var next;

function initFeld() {
	next = readStoreInt('nextFeld');
	
	if(next+1>=FELDER.lenth) {
		writeStore('nextFeld', 0);
	} else {
		writeStore('nextFeld', next+1);
	}
	
	
	FELD = FELDER[next];
	WORTE = WORTER[next];
	
}

function buildtable() {
	
	//var h = $(window).height() - $('.topbar').outerHeight() - $('.bottombar').outerHeight()-40 ;
	
	
	var html = "<table cellspacing=0 width=100% cellpadding=0 class='gametable' >";
	for(var y=0;y<10;y++) {
		html += "<tr>";
		for(var x=0;x<10;x++) {
			html += "<td id='f_"+x+"_"+y+"' onclick='check("+x+","+y+");'>";
			html += FELD[x][y];
			html += "</td>";
		}
		html += "</tr>";
	}
	html += "</table>";
	$('#feld').html(html);
	
	var h = $(window).height() - $('.topbar').outerHeight() - $('.bottombar').outerHeight();
	//$('.gametable').css('height', h);
	
}

function check(x,y) {
	var xx = WORTE[nr].x;
	var yy = WORTE[nr].y;
	if(x==xx && y==yy) {
		setFound();	
	}
	for(var i=1;i<WORTE[nr].l;i++) {
		if(WORTE[nr].d=="h") {
			xx++;
		} else {
			yy++;
		}
		if(x==xx && y==yy) {
			setFound();	
		}
		
	}
}

function setFound() {
	var xx = WORTE[nr].x;
	var yy = WORTE[nr].y;
	for(var i=0;i<WORTE[nr].l;i++) {
		$('#f_'+xx+'_'+yy).css('background-color', 'yellow');
		$('#f_'+xx+'_'+yy).addClass('yellow');
		if(WORTE[nr].d=="h") {
			xx++;
		} else {
			yy++;
		}
	}
	var one = 10000/WORTE.length;
	punkte+=one;
	$('#punkte').html(Math.ceil(punkte)+" Pkt");
	
	nr++;
	if(!checkende()) {
		$('#next').html(WORTE[nr].w);
		$('#anz').html((nr+1)+" / "+WORTE.length);
	}	
	
	var d = new Date();
	startthis = d.getTime();
	
	setTimeout(function() {
			$('.yellow').css('background-color', 'silver');
			$('.yellow').removeClass('yellow');
			
	}, 1000); 
}

function checkende() {
	if(nr>=WORTE.length) {
		
		writeStore('punkte_'+next, Math.ceil(punkte));
		
		running = false;
		$('#timer').html("");
		$('#anz').html(Math.ceil(punkte)+" Punkte");
		$('#punkte').html("");
		$('#next').html("Ende!");
		
		var E = "<div id='endebox' style='position:absolute;display:none;width:"+Math.round($(window).width()*0.8)+"px;text-align:center;'>";
		E += "<button class='bar' onclick=\"window.location='showjs.html';\">Neues Spiel</button><br/><br/>";
		E += "<button class='bar' onclick=\"window.location='index.html';\">Ende</button>";
		E += "</div>";
		
		$('body').append(E);
		$('#endebox').css("top", $(window).height()/2 - $('#endebox').outerHeight()/2);
		$('#endebox').css("left", $(window).width()/2 - $('#endebox').outerWidth()/2);
		
		$('#endebox').fadeIn();
		
		return true;
	}
	return false;
}

function forceNext() {
	var xx = WORTE[nr].x;
	var yy = WORTE[nr].y;
	for(var i=0;i<WORTE[nr].l;i++) {
		$('#f_'+xx+'_'+yy).css('background-color', 'blue');
		$('#f_'+xx+'_'+yy).addClass('blue');
		if(WORTE[nr].d=="h") {
			xx++;
		} else {
			yy++;
		}
	}
	nr++;
	if(!checkende()) {
		$('#next').html(WORTE[nr].w);
		$('#anz').html((nr+1)+" / "+WORTE.length);
		var d = new Date();
		startthis = d.getTime();
	}
	setTimeout(function() {
			$('.blue').css('background-color', 'silver');
			$('.blue').removeClass('blue');
			
	}, 1000);

}

var TimePerWord = 20;

var running=true;
function acttime() {
	if(running) {
		var d = new Date();
		var diff = Math.round(TimePerWord-(d.getTime()-startthis)/1000);
		
		$('#timer').html(diff+" sek");
		if(diff<=0) {
			forceNext();
		}
		
		setTimeout(function() { acttime(); },1000);
	}
	
	resizeTable();
}

function resizeTable() {
	var h = $(window).height() - $('.topbar').outerHeight() - $('.bottombar').outerHeight()-10 ;
	$('.gametable').css('height', h);	
}

var start; 
var startthis;
var punkte=0;
var nr = 0;

function deviceIsReady() {
	$(document).bind('resize', function() {
			resizeTable();
	});
	
	$('#quitbutton').bind("click", function() {
			quitgame();
	} );
	
	initFeld();		
		
	buildtable();
	
	var d = new Date();
	start = d.getTime();
	startthis = d.getTime();
	
	$('#next').html(WORTE[nr].w);
	acttime();
	
		
	$('#anz').html("1 / "+WORTE.length);
	
	if($(window).width()>600) $('.around').css("width", 600);
	resizeTable();
}

function quitgame() {
	
	if(confirm('Spiel beenden?')) {
		window.location = 'index.html';
	}
	
}

setTimeout(function() { 
	deviceIsReady(); 
}, 100);
