reqNoticias = new XMLHttpRequest({ mozSystem: true });

var Noticias = {

	cargar: function(){
		$.mobile.loading('show');
		
		console && console.log("Cargando Noticias - Entro a cargar Noticias");
		
		try {
			var url = "http://www.wradio.com.co/feeds/feedTitulares_2.aspx?version=5";
			console && console.log("Cargando Noticias - tiene el url");
			
			reqNoticias.open('GET',url, true);
			console && console.log("Cargando noticias - abrio la conexion");
			reqNoticias.setRequestHeader("Cache-Control", "no-store");
			reqNoticias.setRequestHeader("Cache-Control", "no-cache");
			reqNoticias.responseType = "text/xml";
			if (reqNoticias.overrideMimeType) {	
				reqNoticias.overrideMimeType('text/xml; charset=utf-8'); //Para Google Chrome y Firefox
			} else {
				reqNoticias.setRequestHeader('Content-type', 'text/html; charset=utf-8'); //Para IE8
			}
			reqNoticias.onreadystatechange = handleResponseNoticias;
			console && console.log("Cargando Noticias - onReadyStateChange");
			reqNoticias.send(null);		

		}
		catch(e) {
			
			alert("Esta aplicaci\xf3n requiere de conexi\xf3n a internet");
			$.mobile.loading('hide');
			console && console.log("Cargando noticias - falla la conexion: el error es: " + e);
			$("#secSinConexion").show();
			$("#recargar").show()
		}
	},
	
	parse: function(ret){

		console && console.log("Cargando Noticias - entro al parse");
		
		var arrayNoticias = [];
		
		$(ret).find("item").each(function(){
			
			entry = { 
				Titulo: $(this).find("title").text(), 
				Link: $(this).find("link").text(),
				Resumen: $(this).find("description").text(),
				Contenido: $(this).find("media\\:description").text(),
				UrlImagen: $(this).find("media\\:thumbnail").attr("url"),
				Autor: $(this).find("author").text(),
				Fecha: $(this).find("pubDate").text()
			};
			
			//console && console.log("Cargando Noticias - buscando los item");
			arrayNoticias.push(entry);
			
		});
		
		this.mostrar(arrayNoticias);
	},
	
	mostrar: function(arrayNoticias){

		$.mobile.loading('hide');
		
		$(".listnews").children().remove('li');
		var s = "";
		var image = "";
		
		for (i = 0; i < arrayNoticias.length ; i++){
			
			var titulo = arrayNoticias[i].Titulo;		
			while(titulo.indexOf("\"") != -1){
				titulo = titulo.replace("\"", "'");
			}
			
			var resumen = arrayNoticias[i].Resumen;		
			while(resumen.indexOf("\"") != -1){
				resumen = resumen.replace("\"", "'");
			}
			
			var contenido = arrayNoticias[i].Contenido;	
			while(contenido.indexOf("\"") != -1){
				contenido = contenido.replace("\"", "'");
			}		
			contenido=contenido.replace(/\r?\n/g, "<br />");
			if(contenido.search(resumen) != -1){
				contenido = contenido.replace(resumen, "");
				contenido = contenido.replace("NTC", "");
			}
			
			if(arrayNoticias[i].UrlImagen.search(".jpg") == -1){
				image = "img/logo_cuadrado.png";
				
			}else
				image = arrayNoticias[i].UrlImagen;
			
			s += '<li class="itemNoticia"><a href="#detalleNoticia" class="contentlinkimg" data-transition="slide" data-titulo="'+titulo+'" data-fecha="'+arrayNoticias[i].Fecha+'" data-imagen="'+arrayNoticias[i].UrlImagen+'" data-resumen="'+resumen+'" data-contenido="'+contenido+'" data-enlace="'+arrayNoticias[i].Link+'" ><div class="articulo centrar" height="250px" style="vertical-align: middle;"  >'+'<div class="imagen" width="80%" ><img width="80%"  src="'+image+'"/></div>'+
			'<div class="info" width="100%"><div class="titulo2">'+cutTitle(titulo)+'</div><div class="fecha">'+arrayNoticias[i].Fecha+'</div>' +	
			'</div></div></a></li>';
		
			
		//console && console.log("Cargando Noticias - el link de la noticia es: " + arrayNoticias[i].Link);
		}
		
		if(arrayNoticias.length > 0){
			
			$(".listnews").html(s);
			$(".listnews").listview('refresh');
			$(".listnews").show();
			
		}else{
			
			$(".listnews").hide();
		}
		
		if(arrayNoticias.length==0){
				
			$("#secSinNoticias").show();
			$("#recargar").show();
		}
		
		$("#nav-panel").panel("close");
	}

};

function handleResponseNoticias(){
	
	if (reqNoticias.readyState === 4) {
		console && console.log("Cargando Noticias - handleResponse - readyState 4");
		//FOR PLAYBOOK, NEED TO CHECK FOR STATUS=0 WHEN XHR REQUESTS ARE MADE TO LOCAL RESOURCES
		//	(NOT NECESSARY FOR SMARTPHONE, WHERE STATUS=200 WILL SUFFICE.
		if (reqNoticias.status === 200 || reqNoticias.status == 304 || reqNoticias.status == 0)  {
			console && console.log("Cargando Noticias - handleResponse - status: "+ reqNoticias.status);
			
			console && console.log("Cargando Noticias - handleResponse - respuesta: " + reqNoticias.responseText);
						
			Noticias.parse(reqNoticias.responseXML);

		}
		else {
			console && console.log("Cargando Noticias - handleResponse - error");
			alert("Error en la conexi\xf3n");
			$.mobile.loading('hide');
		}
	}
};

function cutTitle(titulo){
	//0-77;
	if(titulo.length <= 60){ 
		return titulo;
	}else{
		return titulo.substring(0,59)+"...";
	}
}
