/*
 * JS for Xappy generated by Appery.io
 */

Apperyio.getProjectGUID = function() {
    return '28fc2238-d0a9-4000-b597-43cd9c9927d1';
};

function navigateTo(outcome, useAjax) {
    Apperyio.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Apperyio.adjustContentHeightWithPadding();
}

function adjustContentHeightWithPadding(_page) {
    Apperyio.adjustContentHeightWithPadding(_page);
}

function setDetailContent(pageUrl) {
    Apperyio.setDetailContent(pageUrl);
}

// Appery.io push registration service
var _pushRegistrationApperyService = new Apperyio.RestService({
    'url': 'https://api.appery.io/rest/push/reg',
    'dataType': 'json',
    'type': 'post',
    'contentType': 'application/json',
});

Apperyio.AppPages = [{
    "name": "gameover",
    "location": "#gameover"
}, {
    "name": "Xappy",
    "location": "#Xappy"
}, {
    "name": "game",
    "location": "#game"
}];

function Xappy_js() {

    /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'continue': 'Xappy_continue',
        'bgmusic': 'Xappy_bgmusic',
        'settings': 'Xappy_settings',
        'mobileimage_147': 'Xappy_mobileimage_147',
        'mobilegrid_89': 'Xappy_mobilegrid_89',
        'mobilegridcell_90': 'Xappy_mobilegridcell_90',
        'mobileimage_88': 'Xappy_mobileimage_88',
        'mobilegridcell_92': 'Xappy_mobilegridcell_92',
        'mobilelabel_7_87': 'Xappy_mobilelabel_7_87',
        'mobilegridcell_94': 'Xappy_mobilegridcell_94',
        'mobilegrid_100': 'Xappy_mobilegrid_100',
        'mobilegridcell_101': 'Xappy_mobilegridcell_101',
        'mobileimage_106': 'Xappy_mobileimage_106',
        'mobilegridcell_102': 'Xappy_mobilegridcell_102',
        'mobileimage_107': 'Xappy_mobileimage_107',
        'mobilegridcell_105': 'Xappy_mobilegridcell_105',
        'mobileimage_108': 'Xappy_mobileimage_108',
        'mobilelabel_109': 'Xappy_mobilelabel_109',
        'mobilegridcell_95': 'Xappy_mobilegridcell_95',
        'mobileimage_6': 'Xappy_mobileimage_6',
        'mobilegridcell_96': 'Xappy_mobilegridcell_96',
        'mobilelabel_110': 'Xappy_mobilelabel_110',
        'mobilegridcell_97': 'Xappy_mobilegridcell_97',
        'mobilelabel_111': 'Xappy_mobilelabel_111',
        'mobilegridcell_98': 'Xappy_mobilegridcell_98',
        'mobilelabel_132': 'Xappy_mobilelabel_132',
        'mobilegridcell_99': 'Xappy_mobilegridcell_99',
        'mobilegrid_148': 'Xappy_mobilegrid_148',
        'mobilegridcell_149': 'Xappy_mobilegridcell_149',
        'mobileimage_153': 'Xappy_mobileimage_153',
        'mobilegridcell_150': 'Xappy_mobilegridcell_150',
        'mobilelabel_162': 'Xappy_mobilelabel_162',
        'mobilegridcell_158': 'Xappy_mobilegridcell_158',
        'mobileimage_163': 'Xappy_mobileimage_163',
        'mobilegridcell_159': 'Xappy_mobilegridcell_159',
        'mobilelabel_164': 'Xappy_mobilelabel_164',
        'mobilegridcell_151': 'Xappy_mobilegridcell_151',
        'mobileimage_165': 'Xappy_mobileimage_165',
        'mobilegridcell_152': 'Xappy_mobilegridcell_152',
        'mobilelabel_166': 'Xappy_mobilelabel_166',
        'mobilegridcell_160': 'Xappy_mobilegridcell_160',
        'mobileimage_167': 'Xappy_mobileimage_167',
        'mobilegridcell_161': 'Xappy_mobilegridcell_161',
        'mobilelabel_168': 'Xappy_mobilelabel_168',
        'mobilegrid_25': 'Xappy_mobilegrid_25',
        'mobilegridcell_26': 'Xappy_mobilegridcell_26',
        'mobileimage_31': 'Xappy_mobileimage_31',
        'mobilegridcell_27': 'Xappy_mobilegridcell_27',
        'mobileimage_30': 'Xappy_mobileimage_30',
        'mobilegrid_40': 'Xappy_mobilegrid_40',
        'mobilegridcell_41': 'Xappy_mobilegridcell_41',
        'musicoff': 'Xappy_musicoff',
        'music': 'Xappy_music',
        'soundoff': 'Xappy_soundoff',
        'mobilegridcell_43': 'Xappy_mobilegridcell_43',
        'mobileimage_127': 'Xappy_mobileimage_127',
        'mobilegridcell_45': 'Xappy_mobilegridcell_45',
        'mobileimage_49': 'Xappy_mobileimage_49',
        'mobilegridcell_46': 'Xappy_mobilegridcell_46',
        'credits': 'Xappy_credits',
        'mobilegridcell_47': 'Xappy_mobilegridcell_47',
        'mobileimage_52': 'Xappy_mobileimage_52',
        'mobilegridcell_126': 'Xappy_mobilegridcell_126',
        'hard': 'Xappy_hard',
        'easy': 'Xappy_easy',
        'mobilegrid_57': 'Xappy_mobilegrid_57',
        'mobilegridcell_58': 'Xappy_mobilegridcell_58',
        'mobileimage_86': 'Xappy_mobileimage_86',
        'mobilegridcell_60': 'Xappy_mobilegridcell_60',
        'mobilelabel_56': 'Xappy_mobilelabel_56',
        'mobilegridcell_62': 'Xappy_mobilegridcell_62',
        'mobilelabel_70': 'Xappy_mobilelabel_70',
        'mobilegridcell_63': 'Xappy_mobilegridcell_63',
        'Design': 'Xappy_Design',
        'mobilegridcell_64': 'Xappy_mobilegridcell_64',
        'mobilelabel_72': 'Xappy_mobilelabel_72',
        'mobilegridcell_65': 'Xappy_mobilegridcell_65',
        'mobilelabel_73': 'Xappy_mobilelabel_73',
        'mobilegridcell_66': 'Xappy_mobilegridcell_66',
        'mobilelabel_74': 'Xappy_mobilelabel_74',
        'mobilegridcell_67': 'Xappy_mobilegridcell_67',
        'mobilelabel_75': 'Xappy_mobilelabel_75',
        'mobilelabel_76': 'Xappy_mobilelabel_76',
        'mobilelabel_78': 'Xappy_mobilelabel_78',
        'Richard': 'Xappy_Richard',
        'mobilegridcell_68': 'Xappy_mobilegridcell_68',
        'mobilegrid_80': 'Xappy_mobilegrid_80',
        'mobilegridcell_81': 'Xappy_mobilegridcell_81',
        'mobilelabel_85': 'Xappy_mobilelabel_85',
        'mobilegridcell_82': 'Xappy_mobilegridcell_82',
        'mobileimage_79': 'Xappy_mobileimage_79',
        'mobilegridcell_69': 'Xappy_mobilegridcell_69',
        'vimeo_135': 'Xappy_vimeo_135',
        'mobilegrid_136': 'Xappy_mobilegrid_136',
        'mobilegridcell_137': 'Xappy_mobilegridcell_137',
        'mobileimage_169': 'Xappy_mobileimage_169',
        'mobilegridcell_138': 'Xappy_mobilegridcell_138',
        'mobileimage_134': 'Xappy_mobileimage_134',
        'mobilegridcell_141': 'Xappy_mobilegridcell_141',
        'mobileimage_170': 'Xappy_mobileimage_170'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    /*
     * Nonvisual components
     */

    Apperyio.mappings = Apperyio.mappings || {};

    Apperyio.datasources = Apperyio.datasources || {};

    /*
     * Appery.io Push-notification registration service
     */
    Apperyio.mappings["_pushRegistrationApperyService_onbeforesend"] = {
        "homeScreen": "Xappy",
        "directions": [{
            "from_name": "pushNotificationToken",
            "from_type": "LOCAL_STORAGE",
            "to_name": "_registerPushApperyDS",
            "to_type": "SERVICE_REQUEST",
            "mappings": [{
                "source": "$",
                "target": "$['body']['token']"
            }]
        }, {
            "from_name": "pushNotificationDeviceID",
            "from_type": "LOCAL_STORAGE",
            "to_name": "_registerPushApperyDS",
            "to_type": "SERVICE_REQUEST",
            "mappings": [{
                "source": "$",
                "target": "$['body']['deviceID']"
            }]
        }, {
            "from_name": "deviceTimeZone",
            "from_type": "LOCAL_STORAGE",
            "to_name": "_registerPushApperyDS",
            "to_type": "SERVICE_REQUEST",
            "mappings": [{
                "source": "$",
                "target": "$['body']['timeZone']"
            }]
        }, {
            "to_name": "_registerPushApperyDS",
            "to_type": "SERVICE_REQUEST",
            "mappings": [{
                "target_transformation": function(value) {
                    return Apperyio.getProjectGUID();
                },
                "target": "$['headers']['X-Appery-App-Id']"
            }, {
                "target_transformation": function(value) {
                    return Apperyio.getTargetPlatform();
                },
                "target": "$['body']['type']"
            }]
        }]
    };

    var _registerPushApperyDS = Apperyio.datasources._registerPushApperyDS = new Apperyio.DataSource(_pushRegistrationApperyService, {
        "onBeforeSend": function(jqXHR) {
            Apperyio.processMappingAction(Apperyio.mappings["_pushRegistrationApperyService_onbeforesend"]);
        },
        'onComplete': function(jqXHR, textStatus) {
            Apperyio.refreshScreenFormElements("Xappy");
        },
        'onSuccess': function(data) {
            console.info('App successfully registered with Appery.io Push service');
            $(document).trigger('pushregistrationsuccess');
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            $(document).trigger('pushregistrationfail');
        }
    });

    Apperyio.CurrentScreen = 'Xappy';
    _.chain(Apperyio.mappings).filter(function(m) {
        return m.homeScreen === Apperyio.CurrentScreen;
    }).each(Apperyio.UIHandler.hideTemplateComponents);

    /*
     * Events and handlers
     */

    // On Load
    var Xappy_onLoad = function() {
            Xappy_elementsExtraJS();

            $('div[dsid="mobilecontainer1"]').css('background-image', 'url(' + Appery.getImagePath('cover.png') + ')');
            $('div[dsid="mobilecontainer1"]').css('background-repeat', 'no-repeat');
            $('div[dsid="mobilecontainer1"]').css('background-size', '100% 100%');

            $('div[dsid="mobilecontainer"]').css('background-image', 'url(' + Appery.getImagePath('spacebackground.png') + ')');
            $('div[dsid="mobilecontainer"]').css('background-repeat', 'no-repeat');
            $('div[dsid="mobilecontainer"]').css('background-size', 'cover');

            $('div[dsid="mobilecontainer2"]').css('background-image', 'url(' + Appery.getImagePath('spacebackground.png') + ')');
            $('div[dsid="mobilecontainer2"]').css('background-repeat', 'no-repeat');
            $('div[dsid="mobilecontainer2"]').css('background-size', 'cover');

            //setTimeout( function(){ Apperyio("intro").popup("open", {transition: "none"}); }, 1000);
            try {
                $a.storage["intro"].update("$", "no")
            } catch (e) {
                console.error(e)
            };
            try {
                $a.storage["music"].update("$", "music")
            } catch (e) {
                console.error(e)
            };

            Xappy_deviceEvents();
            Xappy_windowEvents();
            Xappy_elementsEvents();
        };

    // screen window events


    function Xappy_windowEvents() {

        $('#Xappy').bind('pageshow orientationchange', function() {
            var _page = this;
            adjustContentHeightWithPadding(_page);
        });
        $('#Xappy').on({
            pageshow: function(event) {
                var con = localStorage.getItem('continueyn');

                if (con == "yes") {
                    Apperyio("continue").show();

                } else {
                    Apperyio("continue").hide();
                };
            },
        });

    };

    // device events


    function Xappy_deviceEvents() {
        document.addEventListener("deviceready", function() {
            initGA();
            trackPage('Load');
            $(document).off('resume pause push-notification ').on({
                "resume": function(event) {
                    var music = localStorage.getItem('music');

                    if (music == 1) {
                        Apperyio("bgmusic").get(0).play();
                    } else {};
                },
                "pause": function(event) {
                    Apperyio("bgmusic").get(0).pause();;
                },
                "push-notification": function(event) {
                    var data = arguments[0].originalEvent.notification;
                    alert(data.aps.alert);
                },
            });

            $(document).bind("resume", function() {
                PushNotification.getPendingNotifications(function(status) {
                    var notifications = status.notifications;
                    for (var i = 0; i < notifications.length; ++i) {
                        PushNotification.notificationCallback(notifications[i]);
                    }
                });
            });

            $(document).bind("pushinit", function() {
                localStorage.setItem('pushNotificationToken', arguments[1].deviceToken);
                _registerPushApperyDS.execute({});
            });

            var pushNotification = PushNotification;
            pushNotification.getDeviceUniqueIdentifier(function(status) {
                localStorage.setItem('pushNotificationDeviceID', status);
            });

            var offset = new Date().getTimezoneOffset();
            var hr = parseInt(offset / (-60));
            var min = -offset - hr * 60;
            var tmin = '' + min;
            var timezone = 'UTC' + (hr > 0 ? '+' + hr : hr) + ':' + (tmin.length > 1 ? tmin : '0' + tmin);
            localStorage.setItem('deviceTimeZone', timezone);

            pushNotification.registerDevice({
                alert: true,
                badge: true,
                sound: true,
                senderid: '422944410395'
            }, function(status) {
                $(document).trigger('pushinit', status);
            });
        });
    };

    // screen elements extra js


    function Xappy_elementsExtraJS() {
        // screen (Xappy) extra code

        if (Apperyio.getTargetPlatform() == "A") {
            Apperyio.__registerComponent('bgmusic_android', new Apperyio.ApperyMobileAudioComponent("Xappy_bgmusic"));
        }

        /* helppop */
        $("#Xappy_helppop").popup("option", "positionTo", "window");

        /* style */
        $("#Xappy_style").popup("option", "positionTo", "window");

        /* mobilepopup_54 */
        $("#Xappy_mobilepopup_54").popup("option", "positionTo", "window");

        /* intro */
        $("#Xappy_intro").popup("option", "positionTo", "window");

        VimeoPlayer(Apperyio("vimeo_135"));

    };

    // screen elements handler


    function Xappy_elementsEvents() {
        $(document).on("click", "a :input,a a,a fieldset label", function(event) {
            event.stopPropagation();
        });

        $(document).off("tap", '#Xappy_mobilecontainer1 [name="continue"]').on({
            tap: function(event) {
                try {
                    $a.storage["continueyn"].update("$", "yes")
                } catch (e) {
                    console.error(e)
                };
                Apperyio.navigateTo('game', {
                    reverse: false
                });
                try {
                    $a.storage["panelskip"].update("$", "false")
                } catch (e) {
                    console.error(e)
                };
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_mobilecontainer1 [name="continue"]');

        $(document).off("tap", '#Xappy_mobilecontainer1 [name="settings"]').on({
            tap: function(event) {
                $('[id="Xappy_styleslide"]').panel("open");
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_mobilecontainer1 [name="settings"]');
        $(document).off("tap", '#Xappy_mobilecontainer1 [name="mobileimage_147"]').on({
            tap: function(event) {
                var popupElement = Apperyio("style");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "none",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "none"
                    });
                };
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_mobilecontainer1 [name="mobileimage_147"]');

        $(document).off("click", '#Xappy_helppop').on({
            click: function(event) {
                if (!$(this).attr('disabled')) {
                    Apperyio('helppop').popup('close');

                }
            },
        }, '#Xappy_helppop');

        $(document).off("tap", '#Xappy_style [name="mobileimage_31"]').on({
            tap: function(event) {
                var music = localStorage.getItem('music');

                if (music == "music") {
                    Apperyio("bgmusic").get(0).play();
                } else {};
                try {
                    $a.storage["style"].update("$", "box")
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.storage["continueyn"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
                Apperyio.navigateTo('game', {
                    transition: 'none',
                    reverse: false
                });
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_style [name="mobileimage_31"]');

        $(document).off("tap", '#Xappy_style [name="mobileimage_30"]').on({
            tap: function(event) {
                try {
                    $a.storage["continueyn"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.storage["style"].update("$", "circle")
                } catch (e) {
                    console.error(e)
                };
                var music = localStorage.getItem('music');

                if (music == "music") {
                    Apperyio("bgmusic").get(0).play();
                } else {};
                Apperyio.navigateTo('game', {
                    transition: 'none',
                    reverse: false
                });
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_style [name="mobileimage_30"]');

        $(document).off("tap", '#Xappy_styleslide [name="musicoff"]').on({
            tap: function(event) {
                Apperyio("bgmusic").get(0).pause();
                localStorage.setItem('music', "musicoff");
                Apperyio("musicoff").hide();
                Apperyio("music").show();
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="musicoff"]');
        $(document).off("tap", '#Xappy_styleslide [name="music"]').on({
            tap: function(event) {
                Apperyio("bgmusic").get(0).pause();
                localStorage.setItem('music', "soundoff");
                Apperyio("music").hide();
                Apperyio("soundoff").show();
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="music"]');
        $(document).off("tap", '#Xappy_styleslide [name="soundoff"]').on({
            tap: function(event) {
                Apperyio("bgmusic").get(0).play();
                localStorage.setItem('music', "music");
                Apperyio("soundoff").hide();
                Apperyio("musicoff").show();
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="soundoff"]');

        $(document).off("tap", '#Xappy_styleslide [name="mobileimage_127"]').on({
            tap: function(event) {
                var popupElement = Apperyio("intro");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "none",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "none"
                    });
                };
                Apperyio("bgmusic").get(0).pause();;
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="mobileimage_127"]');

        $(document).off("tap", '#Xappy_styleslide [name="mobileimage_49"]').on({
            tap: function(event) {
                var popupElement = Apperyio("helppop");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "pop",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "pop"
                    });
                };
                $('[id="Xappy_styleslide"]').panel("close");
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="mobileimage_49"]');

        $(document).off("tap", '#Xappy_styleslide [name="credits"]').on({
            tap: function(event) {
                var popupElement = Apperyio("mobilepopup_54");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "pop",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "pop"
                    });
                };
                $('[id="Xappy_styleslide"]').panel("close");
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="credits"]');

        $(document).off("tap", '#Xappy_styleslide [name="mobileimage_52"]').on({
            tap: function(event) {
                window.open('https://www.facebook.com/xappyapp', "_system");
                $('[id="Xappy_styleslide"]').panel("close");
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="mobileimage_52"]');

        $(document).off("tap", '#Xappy_styleslide [name="hard"]').on({
            tap: function(event) {
                try {
                    $a.storage["time"].update("$", "notime")
                } catch (e) {
                    console.error(e)
                };
                Apperyio("hard").hide();
                Apperyio("easy").show();;
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="hard"]');
        $(document).off("tap", '#Xappy_styleslide [name="easy"]').on({
            tap: function(event) {
                try {
                    $a.storage["time"].update("$", "time")
                } catch (e) {
                    console.error(e)
                };
                Apperyio("easy").hide();
                Apperyio("hard").show();;
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_styleslide [name="easy"]');

        $(document).off("tap", '#Xappy_mobilepopup_54 [name="mobilelabel_56"]').on({
            tap: function(event) {
                Apperyio('mobilepopup_54').popup('close');
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_mobilepopup_54 [name="mobilelabel_56"]');

        $(document).off("tap", '#Xappy_intro [name="mobileimage_169"]').on({
            tap: function(event) {
                window.open('https://www.youtube.com/watch?v=gkaf4oM-cDg', '_system');
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_intro [name="mobileimage_169"]');

        $(document).off("tap", '#Xappy_intro [name="mobileimage_134"]').on({
            tap: function(event) {
                var music = localStorage.getItem('music');

                if (music == "music") {
                    Apperyio("bgmusic").get(0).play();
                } else {};
                Apperyio('intro').popup('close');
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_intro [name="mobileimage_134"]');

        $(document).off("tap", '#Xappy_intro [name="mobileimage_170"]').on({
            tap: function(event) {
                window.open('https://www.youtube.com/watch?v=2Mq1wfZsOyM', '_system');
                event.stopPropagation();
                return false;
            },
        }, '#Xappy_intro [name="mobileimage_170"]');

    };

    $(document).off("pagebeforeshow", "#Xappy").on("pagebeforeshow", "#Xappy", function(event, ui) {
        Apperyio.CurrentScreen = "Xappy";
        _.chain(Apperyio.mappings).filter(function(m) {
            return m.homeScreen === Apperyio.CurrentScreen;
        }).each(Apperyio.UIHandler.hideTemplateComponents);
    });

    Xappy_onLoad();
};

$(document).off("pagecreate", "#Xappy").on("pagecreate", "#Xappy", function(event, ui) {
    Apperyio.processSelectMenu($(this));
    Xappy_js();
});

function gameover_js() {

    /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'mobilegrid_35': 'gameover_mobilegrid_35',
        'mobilegridcell_36': 'gameover_mobilegridcell_36',
        'mobileimage_41': 'gameover_mobileimage_41',
        'mobilegridcell_37': 'gameover_mobilegridcell_37',
        'mobilegrid_114': 'gameover_mobilegrid_114',
        'mobilegridcell_115': 'gameover_mobilegridcell_115',
        'highscorelabel': 'gameover_highscorelabel',
        'mobilegridcell_116': 'gameover_mobilegridcell_116',
        'mobileimage_56': 'gameover_mobileimage_56',
        'mobilegridcell_38': 'gameover_mobilegridcell_38',
        'mobileimage_18': 'gameover_mobileimage_18',
        'mobilegridcell_39': 'gameover_mobilegridcell_39',
        'mobilegrid_57': 'gameover_mobilegrid_57',
        'mobilegridcell_58': 'gameover_mobilegridcell_58',
        'mobileimage_40': 'gameover_mobileimage_40',
        'mobilegridcell_60': 'gameover_mobilegridcell_60',
        'level_score': 'gameover_level_score',
        'exp': 'gameover_exp',
        'mobilegrid_27': 'gameover_mobilegrid_27',
        'mobilegridcell_28': 'gameover_mobilegridcell_28',
        'mobileimage_49': 'gameover_mobileimage_49',
        'mobilegridcell_29': 'gameover_mobilegridcell_29',
        'mobilegrid_43': 'gameover_mobilegrid_43',
        'mobilegridcell_44': 'gameover_mobilegridcell_44',
        'mobileimage_48': 'gameover_mobileimage_48',
        'mobilegridcell_45': 'gameover_mobilegridcell_45',
        'mobileimage_42': 'gameover_mobileimage_42',
        'mobilenavbar_2': 'gameover_mobilenavbar_2',
        'mobilenavbaritem_3': 'gameover_mobilenavbaritem_3',
        'mobilenavbaritem_20': 'gameover_mobilenavbaritem_20',
        'mobilegrid_63': 'gameover_mobilegrid_63',
        'mobilegridcell_64': 'gameover_mobilegridcell_64',
        'name_input': 'gameover_name_input',
        'mobilegridcell_124': 'gameover_mobilegridcell_124',
        'loction_input': 'gameover_loction_input',
        'mobilegridcell_126': 'gameover_mobilegridcell_126',
        'mobileimage_69': 'gameover_mobileimage_69',
        'mobilegrid_108': 'gameover_mobilegrid_108',
        'mobilegridcell_109': 'gameover_mobilegridcell_109',
        'mobilelabel_107': 'gameover_mobilelabel_107',
        'mobilegridcell_110': 'gameover_mobilegridcell_110',
        'mobilelabel_113': 'gameover_mobilelabel_113',
        'mobilegridcell_117': 'gameover_mobilegridcell_117',
        'level': 'gameover_level',
        'mobilegridcell_118': 'gameover_mobilegridcell_118',
        'Location': 'gameover_Location',
        'scoreTable': 'gameover_scoreTable',
        'mobilegridcell_72': 'gameover_mobilegridcell_72',
        'labelname': 'gameover_labelname',
        'mobilegridcell_73': 'gameover_mobilegridcell_73',
        'labelscore': 'gameover_labelscore',
        'mobilegridcell_121': 'gameover_mobilegridcell_121',
        'labellevel': 'gameover_labellevel',
        'mobilegridcell_122': 'gameover_mobilegridcell_122',
        'labellocation': 'gameover_labellocation'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    /*
     * Nonvisual components
     */

    Apperyio.mappings = Apperyio.mappings || {};

    Apperyio.mappings["gameover_table_onbeforesend_mapping_0"] = {
        "homeScreen": "gameover",
        "directions": [

        {

            "to_name": "table",
            "to_type": "SERVICE_REQUEST",

            "to_default": {
                "headers": {
                    "X-Appery-Database-Id": "{database_id}"
                },
                "parameters": {
                    "sort": "-score"
                },
                "body": null
            },

            "mappings": []
        }

        ]
    };

    Apperyio.mappings["gameover_table_onsuccess_mapping_0"] = {
        "homeScreen": "gameover",
        "directions": [

        {
            "from_name": "table",
            "from_type": "SERVICE_RESPONSE",

            "to_name": "gameover",
            "to_type": "UI",

            "mappings": [

            {

                "source": "$['body'][i]['location']",
                "target": "$['scoreTable']['labellocation:text']"

            },

            {

                "source": "$['body'][i]['level']",
                "target": "$['scoreTable']['labellevel:text']"

            },

            {

                "source": "$['body'][i]['score']",
                "target": "$['scoreTable']['labelscore:text']"

            },

            {

                "source": "$['body'][i]['name']",
                "target": "$['scoreTable']['labelname:text']"

            },

            {

                "source": "$['body'][i]",
                "target_transformation": function(value, element) {
                    if (count > maxCount) {
                        element.hide();
                    } else {
                        count++;
                    }

                },
                "target": "$['scoreTable']"

            }

            ]
        }

        ]
    };

    Apperyio.mappings["gameover_submit_onbeforesend_mapping_0"] = {
        "homeScreen": "gameover",
        "directions": [

        {
            "from_name": "level",
            "from_type": "LOCAL_STORAGE",

            "to_name": "submit",
            "to_type": "SERVICE_REQUEST",

            "to_default": {
                "headers": {
                    "X-Appery-Database-Id": "{database_id}",
                    "Content-Type": "application/json"
                },
                "parameters": {},
                "body": {
                    "acl": {
                        "*": {
                            "write": true,
                            "read": true
                        }
                    }
                }
            },

            "mappings": [

            {

                "source": "$",
                "target": "$['body']['level']"

            }

            ]
        },

        {
            "from_name": "score",
            "from_type": "LOCAL_STORAGE",

            "to_name": "submit",
            "to_type": "SERVICE_REQUEST",

            "to_default": {
                "headers": {
                    "X-Appery-Database-Id": "{database_id}",
                    "Content-Type": "application/json"
                },
                "parameters": {},
                "body": {
                    "acl": {
                        "*": {
                            "write": true,
                            "read": true
                        }
                    }
                }
            },

            "mappings": [

            {

                "source": "$",
                "target": "$['body']['score']"

            }

            ]
        },

        {
            "from_name": "name",
            "from_type": "LOCAL_STORAGE",

            "to_name": "submit",
            "to_type": "SERVICE_REQUEST",

            "to_default": {
                "headers": {
                    "X-Appery-Database-Id": "{database_id}",
                    "Content-Type": "application/json"
                },
                "parameters": {},
                "body": {
                    "acl": {
                        "*": {
                            "write": true,
                            "read": true
                        }
                    }
                }
            },

            "mappings": [

            {

                "source": "$",
                "target": "$['body']['name']"

            }

            ]
        },

        {
            "from_name": "loc",
            "from_type": "LOCAL_STORAGE",

            "to_name": "submit",
            "to_type": "SERVICE_REQUEST",

            "to_default": {
                "headers": {
                    "X-Appery-Database-Id": "{database_id}",
                    "Content-Type": "application/json"
                },
                "parameters": {},
                "body": {
                    "acl": {
                        "*": {
                            "write": true,
                            "read": true
                        }
                    }
                }
            },

            "mappings": [

            {

                "source": "$",
                "target": "$['body']['location']"

            }

            ]
        }

        ]
    };

    Apperyio.mappings["gameover_submit_onsuccess_mapping_0"] = {
        "homeScreen": "gameover",
        "directions": []
    };

    Apperyio.datasources = Apperyio.datasources || {};

    window.table = Apperyio.datasources.table = new Apperyio.DataSource(xappy_push_highscores_list_service, {
        "onBeforeSend": function(jqXHR) {
            Apperyio.processMappingAction(Apperyio.mappings["gameover_table_onbeforesend_mapping_0"]);
            count = 0;;
        },
        "onComplete": function(jqXHR, textStatus) {

            Apperyio.refreshScreenFormElements("Xappy");
        },
        "onSuccess": function(data) {
            Apperyio.processMappingAction(Apperyio.mappings["gameover_table_onsuccess_mapping_0"]);
        },
        "onError": function(jqXHR, textStatus, errorThrown) {}
    });

    window.submit = Apperyio.datasources.submit = new Apperyio.DataSource(xappy_push_highscores_create_service, {
        "onBeforeSend": function(jqXHR) {
            Apperyio.processMappingAction(Apperyio.mappings["gameover_submit_onbeforesend_mapping_0"]);
        },
        "onComplete": function(jqXHR, textStatus) {

            Apperyio.refreshScreenFormElements("Xappy");
        },
        "onSuccess": function(data) {
            Apperyio.processMappingAction(Apperyio.mappings["gameover_submit_onsuccess_mapping_0"]);
        },
        "onError": function(jqXHR, textStatus, errorThrown) {}
    });

    Apperyio.CurrentScreen = 'gameover';
    _.chain(Apperyio.mappings).filter(function(m) {
        return m.homeScreen === Apperyio.CurrentScreen;
    }).each(Apperyio.UIHandler.hideTemplateComponents);

    /*
     * Events and handlers
     */

    // On Load
    var gameover_onLoad = function() {
            gameover_elementsExtraJS();

            gameover_deviceEvents();
            gameover_windowEvents();
            gameover_elementsEvents();
        };

    // screen window events


    function gameover_windowEvents() {

        $('#gameover').bind('pageshow orientationchange', function() {
            var _page = this;
            adjustContentHeightWithPadding(_page);
        });
        $('#gameover').on({
            pageshow: function(event) { //var hs =Apperyio('highscorehold').val();
                //var scorenow =Apperyio('scorehold').val();
                var sound = localStorage.getItem('music');
                var hs = parseInt(Apperyio.storage.HighScore.get());
                var scorenow = parseInt(Apperyio.storage.score.get());
                if (isNaN(hs)) hs = 1; {

                }
                if (scorenow > hs) {
                    hs = scorenow;
                }

                Apperyio('highscorelabel').text(hs);
                resettime();
                if (sound == "music") {
                    Apperyio("exp").get(0).play();
                } else if (sound == "musicoff") {
                    Apperyio("exp").get(0).play();
                } else {};
                initGA();
                trackPage('gameover');
                try {
                    $a.storage["HighScore"].update("$", $a.c15r($a.UIHandler.resolveGeneratedComponent('highscorelabel', this), 'get', 'text'))
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.c15r("level_score", "set", "text", $a.storage["score"].get("$"))
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.c15r("name_input", "set", "text", $a.storage["name"].get("$"))
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.c15r("loction_input", "set", "text", $a.storage["loc"].get("$"))
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.storage["continueyn"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
            },
        });

    };

    // device events


    function gameover_deviceEvents() {
        document.addEventListener("deviceready", function() {
            $(document).off('resume pause ').on({
                "resume": function(event) {
                    var music = localStorage.getItem('music');

                    if (music == 1) {
                        Apperyio("bgmusic").get(0).play();
                    } else {};
                },
                "pause": function(event) {
                    Apperyio.navigateTo('Xappy', {
                        transition: 'none',
                        reverse: false
                    });
                    Apperyio("bgmusic").get(0).pause();;
                },
            });

        });
    };

    // screen elements extra js


    function gameover_elementsExtraJS() {
        // screen (gameover) extra code

        if (Apperyio.getTargetPlatform() == "A") {
            Apperyio.__registerComponent('exp_android', new Apperyio.ApperyMobileAudioComponent("gameover_exp"));
        }

        /* submitPop */
        $("#gameover_submitPop").popup("option", "positionTo", "window");

        /* table */
        $("#gameover_table").popup("option", "positionTo", "window");

    };

    // screen elements handler


    function gameover_elementsEvents() {
        $(document).on("click", "a :input,a a,a fieldset label", function(event) {
            event.stopPropagation();
        });

        $(document).off("tap", '#gameover_mobilecontainer [name="mobileimage_56"]').on({
            tap: function(event) {
                var popupElement = Apperyio("submitPop");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "pop",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "pop"
                    });
                };
                event.stopPropagation();
                return false;
            },
        }, '#gameover_mobilecontainer [name="mobileimage_56"]');

        $(document).off("tap", '#gameover_mobilecontainer [name="mobileimage_18"]').on({
            tap: function(event) {
                try {
                    table.execute({});
                } catch (e) {
                    console.error(e);
                    hideSpinner();
                };
                var popupElement = Apperyio("table");
                if (popupElement.popup("option", "positionTo") === "origin") {
                    popupElement.popup("open", {
                        transition: "pop",
                        positionTo: "#" + $(this).attr("id")
                    });
                } else {
                    popupElement.popup("open", {
                        transition: "pop"
                    });
                };
                event.stopPropagation();
                return false;
            },
        }, '#gameover_mobilecontainer [name="mobileimage_18"]');

        $(document).off("tap", '#gameover_mobilecontainer [name="mobileimage_48"]').on({
            tap: function(event) {
                window.open('https://www.facebook.com/xappyapp', "_system");
                try {
                    $a.c15r("level_score", "set", "text", $a.storage["score"].get("$"))
                } catch (e) {
                    console.error(e)
                };
                event.stopPropagation();
                return false;
            },
        }, '#gameover_mobilecontainer [name="mobileimage_48"]');

        $(document).off("tap", '#gameover_mobilecontainer [name="mobileimage_42"]').on({
            tap: function(event) {
                resettime();
                Apperyio.navigateTo('Xappy', {
                    reverse: false
                });
                try {
                    $a.storage["continueyn"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.storage["panelskip"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
                event.stopPropagation();
                return false;
            },
        }, '#gameover_mobilecontainer [name="mobileimage_42"]');

        $(document).off("vclick", '#gameover_mobilefooter [name="mobilenavbaritem_3"]').on({
            vclick: function(event) {
                Apperyio.navigateTo('game', {
                    reverse: false
                });
            },
        }, '#gameover_mobilefooter [name="mobilenavbaritem_3"]');
        $(document).off("tap", '#gameover_mobilefooter [name="mobilenavbaritem_20"]').on({
            tap: function(event) {
                window.open('https://www.facebook.com/xappyapp', "_system");
                event.stopPropagation();
                return false;
            },
        }, '#gameover_mobilefooter [name="mobilenavbaritem_20"]');

        $(document).off("tap", '#gameover_submitPop [name="mobileimage_69"]').on({
            tap: function(event) {
                try {
                    $a.storage["name"].update("$", $a.c15r($a.UIHandler.resolveGeneratedComponent('name_input', this), 'get', 'text'))
                } catch (e) {
                    console.error(e)
                };
                try {
                    $a.storage["loc"].update("$", $a.c15r($a.UIHandler.resolveGeneratedComponent('loction_input', this), 'get', 'text'))
                } catch (e) {
                    console.error(e)
                };
                Apperyio('submitPop').popup('close');
                try {
                    submit.execute({});
                } catch (e) {
                    console.error(e);
                    hideSpinner();
                };
                event.stopPropagation();
                return false;
            },
        }, '#gameover_submitPop [name="mobileimage_69"]');

    };

    $(document).off("pagebeforeshow", "#gameover").on("pagebeforeshow", "#gameover", function(event, ui) {
        Apperyio.CurrentScreen = "gameover";
        _.chain(Apperyio.mappings).filter(function(m) {
            return m.homeScreen === Apperyio.CurrentScreen;
        }).each(Apperyio.UIHandler.hideTemplateComponents);
    });

    gameover_onLoad();
};

$(document).off("pagecreate", "#gameover").on("pagecreate", "#gameover", function(event, ui) {
    Apperyio.processSelectMenu($(this));
    gameover_js();
});

function game_js() {

    /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'grid': 'game_grid',
        'mobilegridcell_84': 'game_mobilegridcell_84',
        'xappy_html': 'game_xappy_html',
        'mobilegridcell_85': 'game_mobilegridcell_85',
        'mobilegrid_93': 'game_mobilegrid_93',
        'mobilegridcell_94': 'game_mobilegridcell_94',
        'mobileimage_118': 'game_mobileimage_118',
        'mobilegridcell_95': 'game_mobilegridcell_95',
        'newscore_label': 'game_newscore_label',
        'mobilegridcell_195': 'game_mobilegridcell_195',
        'mobileimage_106': 'game_mobileimage_106',
        'mobilegridcell_196': 'game_mobilegridcell_196',
        'score_label': 'game_score_label',
        'mobileimage_98': 'game_mobileimage_98',
        'x_input': 'game_x_input',
        'mobileimage_99': 'game_mobileimage_99',
        'y_input': 'game_y_input',
        'mobilegrid_100': 'game_mobilegrid_100',
        'mobilegridcell_101': 'game_mobilegridcell_101',
        'mobilegrid_108': 'game_mobilegrid_108',
        'mobilegridcell_109': 'game_mobilegridcell_109',
        'mobilegridcell_110': 'game_mobilegridcell_110',
        'mobilegrid_187': 'game_mobilegrid_187',
        'mobilegridcell_188': 'game_mobilegridcell_188',
        'mobileimage_192': 'game_mobileimage_192',
        'mobilegridcell_189': 'game_mobilegridcell_189',
        'timer': 'game_timer',
        'mobilegridcell_102': 'game_mobilegridcell_102',
        'mobileimage_105': 'game_mobileimage_105',
        'rank1': 'game_rank1',
        'rank4': 'game_rank4',
        'rank2': 'game_rank2',
        'laser': 'game_laser',
        'rank3': 'game_rank3',
        'bugle': 'game_bugle',
        'mobileimage_44': 'game_mobileimage_44',
        'mobilelabel_50': 'game_mobilelabel_50',
        'mobilelabel_49': 'game_mobilelabel_49',
        'mobileimage_46': 'game_mobileimage_46',
        'mobileimage_48': 'game_mobileimage_48',
        'mobilelabel_51': 'game_mobilelabel_51',
        'mobilegrid_149_165': 'game_mobilegrid_149_165',
        'mobilegridcell_150_166': 'game_mobilegridcell_150_166',
        'mobilegrid_171': 'game_mobilegrid_171',
        'mobilegridcell_172': 'game_mobilegridcell_172',
        'mobilelabel_186': 'game_mobilelabel_186',
        'mobilegridcell_173': 'game_mobilegridcell_173',
        'score2': 'game_score2',
        'mobilegridcell_176': 'game_mobilegridcell_176',
        'mobileimage_178': 'game_mobileimage_178',
        'mobilegridcell_152_168': 'game_mobilegridcell_152_168',
        'mobilegridcell_154_170': 'game_mobilegridcell_154_170',
        'mobilegrid_179': 'game_mobilegrid_179',
        'mobilegridcell_180': 'game_mobilegridcell_180',
        'message': 'game_message',
        'mobilegridcell_181': 'game_mobilegridcell_181',
        'mobileimage_185': 'game_mobileimage_185',
        'notimelabel': 'game_notimelabel',
        'timelabel': 'game_timelabel'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    /*
     * Nonvisual components
     */

    Apperyio.mappings = Apperyio.mappings || {};

    Apperyio.datasources = Apperyio.datasources || {};

    Apperyio.CurrentScreen = 'game';
    _.chain(Apperyio.mappings).filter(function(m) {
        return m.homeScreen === Apperyio.CurrentScreen;
    }).each(Apperyio.UIHandler.hideTemplateComponents);

    /*
     * Events and handlers
     */

    // On Load
    var game_onLoad = function() {
            game_elementsExtraJS();

            game_deviceEvents();
            game_windowEvents();
            game_elementsEvents();
        };

    // screen window events


    function game_windowEvents() {

        $('#game').bind('pageshow orientationchange', function() {
            var _page = this;
            adjustContentHeightWithPadding(_page);
        });
        $('#game').on({
            pagehide: function(event) {
                resettime();
            },
            pageshow: function(event) {
                Appery("grid").css("height", '100%');
                Appery("grid").parent().css("height", Appery("grid").css("height"));;
                var time = localStorage.getItem('time');
                var con = localStorage.getItem('continueyn');

                if (con == "yes") {

                    var x = localStorage.getItem('x');
                    var xx = localStorage.getItem('xx');
                    var y = localStorage.getItem('y');
                    var yy = localStorage.getItem('yy');
                    var xy = localStorage.getItem('xy');
                    var score = localStorage.getItem('score');
                    var level = localStorage.getItem('level');

                    resettime();
                    // countdown();
                    if (time == "notime") {
                        Apperyio("timelabel").hide();
                        Apperyio("notimelabel").show();
                    } else {
                        localStorage.setItem('continueclockyn', "yes");
                        countdown();

                        Apperyio("timelabel").show();
                        Apperyio("notimelabel").hide();
                    }

                    var style = localStorage.getItem('style');
                    console.log("style");
                    if (style == "circle") {

                        var s = document.getElementById("graph");
                        var w = s.width;
                        s.width = 10;
                        s.width = w;

                        Apperyio('score_label').text(level);
                        Apperyio('newscore_label').text(score);

                        var xlaura = x;
                        var ylaura = parseInt(y);
                        console.log("set from storage");
                        var xybeg = parseInt(xy);

                        // graph
                        var graph;
                        var xPadding = 0;
                        var yPadding = 0;

                        // Returns the max Y value in our data list
                        getMaxY = 100;
                        data_values = 100;

                        // Return the x pixel for a graph point


                        function getXPixel(val) {
                            return ((graph.width() - xPadding) / data_values) * val + (xPadding * 1.5);
                        }

                        // Return the y pixel for a graph point


                        function getYPixel(val) {
                            return graph.height() - (((graph.height() - yPadding) / getMaxY) * val) - yPadding;
                        }

                        console.log("start draw");
                        $(document).ready(function() {
                            graph = $('#graph');
                            var c = graph[0].getContext('2d');

                            c.lineWidth = 8;
                            c.strokeStyle = '#5E87B0';
                            c.font = 'italic 8pt sans-serif';
                            c.textAlign = "center";

                            // Draw the axises
                            c.beginPath();
                            c.moveTo(xPadding, 0);
                            c.lineTo(xPadding, graph.height() - yPadding);
                            c.lineTo(graph.width(), graph.height() - yPadding);
                            c.stroke();

                            c.lineWidth = 4;
                            c.strokeStyle = '#B80000 ';
                            c.beginPath();
                            c.moveTo(getXPixel(100), getYPixel(100));
                            c.lineTo(getXPixel(100), getYPixel(100));
                            // Draw the line graph

                            c.beginPath();
                            c.arc(getXPixel(xlaura), getYPixel(ylaura), getXPixel(xybeg), 0, 2 * Math.PI);
                            c.stroke();

                            var picX = xlaura - xybeg;
                            var picY = ylaura + xybeg;
                            var picL = xybeg * 2;

                            var img = new Image();
                            img.onload = function() {
                                c.drawImage(img, getXPixel(picX), getYPixel(picY), getXPixel(picL), getXPixel(picL));

                            };
                            img.src = "files/views/assets/image/flysaucer.png";

                            console.log("end draw");

                        });
                        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    } else {
                        var s = document.getElementById("graph");
                        var w = s.width;
                        s.width = 10;
                        s.width = w;

                        Apperyio('score_label').text(level);
                        Apperyio('newscore_label').text(score);

                        var xybeg = xy;
                        var xxbeg = x;
                        var yybeg = y;

                        var xxxbeg = xx;
                        var yyybeg = yy;

                        // graph
                        var graph;
                        var xPadding = 0;
                        var yPadding = 0;

                        // Returns the max Y value in our data list
                        getMaxY = 100;
                        data_values = 100;

                        // Return the x pixel for a graph point


                        function getXPixel(val) {
                            return ((graph.width() - xPadding) / data_values) * val + (xPadding * 1.5);
                        }

                        // Return the y pixel for a graph point


                        function getYPixel(val) {
                            return graph.height() - (((graph.height() - yPadding) / getMaxY) * val) - yPadding;
                        }

                        $(document).ready(function() {
                            graph = $('#graph');
                            var c = graph[0].getContext('2d');

                            c.lineWidth = 8;
                            c.strokeStyle = '#5E87B0';
                            c.font = 'italic 8pt sans-serif';
                            c.textAlign = "center";

                            // Draw the axises
                            c.beginPath();
                            c.moveTo(xPadding, 0);
                            c.lineTo(xPadding, graph.height() - yPadding);
                            c.lineTo(graph.width(), graph.height() - yPadding);
                            c.stroke();

                            c.lineWidth = 4;
                            c.strokeStyle = '#B80000 ';
                            c.beginPath();
                            c.moveTo(getXPixel(100), getYPixel(100));
                            c.lineTo(getXPixel(100), getYPixel(100));
                            // Draw the line graph
                            c.beginPath();
                            c.moveTo(getXPixel(xxbeg), getYPixel(yybeg));

                            c.lineTo(getXPixel(xxbeg), getYPixel(yyybeg));

                            c.lineTo(getXPixel(xxxbeg), getYPixel(yyybeg));
                            c.lineTo(getXPixel(xxxbeg), getYPixel(yybeg));
                            c.lineTo(getXPixel(xxbeg), getYPixel(yybeg));
                            c.stroke();

                            var img = new Image();
                            img.onload = function() {
                                c.drawImage(img, getXPixel(xxbeg), getYPixel(yyybeg), getXPixel(xybeg), getXPixel(xybeg));

                            };
                            img.src = "files/views/assets/image/spaceship.png";

                        });

                    }

                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////
                } else {

                    Apperyio("rank2").hide();
                    Apperyio("rank3").hide();
                    Apperyio("rank4").hide();
                    Apperyio("rank1").show();

                    if (time == "notime") {

                        Apperyio("timelabel").hide();
                        Apperyio("notimelabel").show();
                    } else {

                        Apperyio("timelabel").show();
                        Apperyio("notimelabel").hide();
                    }
                    // Appery("level").parent().css({top: "0px", right: "0px"});

                    var intro = localStorage.getItem('intro');
                    if (intro != "Stop showing introduction") {
                        Apperyio("intro").popup("open");
                    }

                    var style = localStorage.getItem('style');
                    console.log("style");
                    if (style == "circle") {

                        var s = document.getElementById("graph");
                        var w = s.width;
                        s.width = 10;
                        s.width = w;

                        Apperyio('score_label').text(1);
                        Apperyio('newscore_label').text(0);

                        var xlaura = Math.floor((Math.random() * 100) + 1); //x start 
                        var ylaura = Math.floor((Math.random() * 100) + 1); //y start
                        console.log("random");
                        var xybeg = 20;

                        if (xlaura > 74) {

                            xlaura = 74;
                        } else {

                        }

                        if (xlaura < 24) {

                            xlaura = 24;
                        } else {

                        }

                        if (ylaura > 74) {

                            ylaura = 74;
                        } else {

                        }

                        if (ylaura < 24) {

                            ylaura = 24;
                        } else {

                        }
                        console.log("start storage");
                        localStorage.setItem('score', 0);
                        localStorage.setItem('level', 1);
                        localStorage.setItem('x', xlaura);
                        localStorage.setItem('y', ylaura);
                        localStorage.setItem('xy', xybeg);

                        console.log("end storage");

                        // graph
                        var graph;
                        var xPadding = 0;
                        var yPadding = 0;

                        // Returns the max Y value in our data list
                        getMaxY = 100;
                        data_values = 100;

                        // Return the x pixel for a graph point


                        function getXPixel(val) {
                            return ((graph.width() - xPadding) / data_values) * val + (xPadding * 1.5);
                        }

                        // Return the y pixel for a graph point


                        function getYPixel(val) {
                            return graph.height() - (((graph.height() - yPadding) / getMaxY) * val) - yPadding;
                        }

                        console.log("start draw");
                        $(document).ready(function() {
                            graph = $('#graph');
                            var c = graph[0].getContext('2d');

                            c.lineWidth = 8;
                            c.strokeStyle = '#5E87B0';
                            c.font = 'italic 8pt sans-serif';
                            c.textAlign = "center";

                            // Draw the axises
                            c.beginPath();
                            c.moveTo(xPadding, 0);
                            c.lineTo(xPadding, graph.height() - yPadding);
                            c.lineTo(graph.width(), graph.height() - yPadding);
                            c.stroke();

                            c.lineWidth = 4;
                            c.strokeStyle = '#B80000 ';
                            c.beginPath();
                            c.moveTo(getXPixel(100), getYPixel(100));
                            c.lineTo(getXPixel(100), getYPixel(100));
                            // Draw the line graph

                            c.beginPath();
                            c.arc(getXPixel(xlaura), getYPixel(ylaura), getXPixel(xybeg), 0, 2 * Math.PI);
                            c.stroke();
                            var picX = xlaura - xybeg;
                            var picY = ylaura + xybeg;
                            var picL = xybeg * 2;

                            var img = new Image();
                            img.onload = function() {
                                c.drawImage(img, getXPixel(picX), getYPixel(picY), getXPixel(picL), getXPixel(picL));

                            };
                            img.src = "files/views/assets/image/flysaucer.png";

                            console.log("end draw");

                        });
                        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    } else {
                        var s = document.getElementById("graph");
                        var w = s.width;
                        s.width = 10;
                        s.width = w;

                        Apperyio('score_label').text(1);
                        Apperyio('newscore_label').text(0);

                        var xlaura = Math.floor((Math.random() * 100) + 1); //x start 
                        var ylaura = Math.floor((Math.random() * 100) + 1); //y start
                        var xybeg = 30;
                        var xxbeg = xlaura;
                        var yybeg = ylaura;

                        var xover = 94 - xybeg;
                        var yover = 94 - xybeg;

                        if (xlaura > xover) {
                            xxbeg = xover;
                        } else {
                            xxbeg = xlaura;
                        }
                        if (ylaura > yover) {
                            yybeg = yover;
                        } else {
                            yybeg = ylaura;
                        }

                        var xxxbeg = xxbeg + xybeg;
                        var yyybeg = yybeg + xybeg;

                        localStorage.setItem('score', 0);
                        localStorage.setItem('level', 1);
                        localStorage.setItem('x', xxbeg);
                        localStorage.setItem('y', yybeg);
                        localStorage.setItem('xy', xybeg);
                        localStorage.setItem('xx', xxxbeg);
                        localStorage.setItem('yy', yyybeg);

                        // graph
                        var graph;
                        var xPadding = 0;
                        var yPadding = 0;

                        // Returns the max Y value in our data list
                        getMaxY = 100;
                        data_values = 100;

                        // Return the x pixel for a graph point


                        function getXPixel(val) {
                            return ((graph.width() - xPadding) / data_values) * val + (xPadding * 1.5);
                        }

                        // Return the y pixel for a graph point


                        function getYPixel(val) {
                            return graph.height() - (((graph.height() - yPadding) / getMaxY) * val) - yPadding;
                        }

                        $(document).ready(function() {
                            graph = $('#graph');
                            var c = graph[0].getContext('2d');

                            c.lineWidth = 8;
                            c.strokeStyle = '#5E87B0';
                            c.font = 'italic 8pt sans-serif';
                            c.textAlign = "center";

                            // Draw the axises
                            c.beginPath();
                            c.moveTo(xPadding, 0);
                            c.lineTo(xPadding, graph.height() - yPadding);
                            c.lineTo(graph.width(), graph.height() - yPadding);
                            c.stroke();

                            c.lineWidth = 4;
                            c.strokeStyle = '#B80000 ';
                            c.beginPath();
                            c.moveTo(getXPixel(100), getYPixel(100));
                            c.lineTo(getXPixel(100), getYPixel(100));
                            // Draw the line graph
                            c.beginPath();
                            c.moveTo(getXPixel(xxbeg), getYPixel(yybeg));

                            c.lineTo(getXPixel(xxbeg), getYPixel(yyybeg));

                            c.lineTo(getXPixel(xxxbeg), getYPixel(yyybeg));
                            c.lineTo(getXPixel(xxxbeg), getYPixel(yybeg));
                            c.lineTo(getXPixel(xxbeg), getYPixel(yybeg));
                            c.stroke();

                            var img = new Image();
                            img.onload = function() {
                                c.drawImage(img, getXPixel(xxbeg), getYPixel(yyybeg), getXPixel(xybeg), getXPixel(xybeg));

                            };
                            img.src = "files/views/assets/image/spaceship.png";

                        });
                    }

                };
                try {
                    $a.storage["continueyn"].update("$", "no")
                } catch (e) {
                    console.error(e)
                };
            },
        });

    };

    // device events


    function game_deviceEvents() {
        document.addEventListener("deviceready", function() {
            $(document).off('pause resume ').on({
                "pause": function(event) {
                    Apperyio.navigateTo('Xappy', {
                        transition: 'none',
                        reverse: false
                    });
                    Apperyio("bgmusic").get(0).pause();;
                },
                "resume": function(event) {
                    var music = localStorage.getItem('music');

                    if (music == 1) {
                        Apperyio("bgmusic").get(0).play();
                    } else {};
                },
            });

        });
    };

    // screen elements extra js


    function game_elementsExtraJS() {
        // screen (game) extra code

        if (Apperyio.getTargetPlatform() == "A") {
            Apperyio.__registerComponent('laser_android', new Apperyio.ApperyMobileAudioComponent("game_laser"));
        }

        if (Apperyio.getTargetPlatform() == "A") {
            Apperyio.__registerComponent('bugle_android', new Apperyio.ApperyMobileAudioComponent("game_bugle"));
        }

        /* piepopup */
        $("#game_piepopup").popup("option", "positionTo", "window");

        /* barpopup */
        $("#game_barpopup").popup("option", "positionTo", "window");

        /* radialpopup */
        $("#game_radialpopup").popup("option", "positionTo", "window");

    };

    // screen elements handler


    function game_elementsEvents() {
        $(document).on("click", "a :input,a a,a fieldset label", function(event) {
            event.stopPropagation();
        });

        $(document).off("tap", '#game_mobilecontainer2 [name="mobileimage_105"]').on({
            tap: function(event) {
                var music = localStorage.getItem('music');

                if (music == "music") {
                    Apperyio("laser").get(0).play();
                } else if (music == "musicoff") {
                    Apperyio("laser").get(0).play();
                } else {}

                var x = Apperyio('x_input').val();
                var y = Apperyio('y_input').val();
                console.log("input");

                var graph;
                var xPadding = 0;
                var yPadding = 0;

                // Returns the max Y value in our data list
                getMaxY = 100;
                data_values = 100;

                // Return the x pixel for a graph point


                function getXPixel(val) {
                    return ((graph.width() - xPadding) / data_values) * val + (xPadding * 1.5);
                }

                // Return the y pixel for a graph point


                function getYPixel(val) {
                    return graph.height() - (((graph.height() - yPadding) / getMaxY) * val) - yPadding;
                }
                console.log("start draw2");
                $(document).ready(function() {
                    graph = $('#graph');
                    var c = graph[0].getContext('2d');

                    c.lineWidth = 8;
                    c.strokeStyle = '#5E87B0';
                    c.font = 'italic 8pt sans-serif';
                    c.textAlign = "center";

                    // Draw the axises
                    c.beginPath();
                    c.moveTo(xPadding, 0);
                    c.lineTo(xPadding, graph.height() - yPadding);
                    c.lineTo(graph.width(), graph.height() - yPadding);
                    c.stroke();

                    c.lineWidth = 4;
                    c.strokeStyle = '#0000FF';
                    c.beginPath();
                    c.moveTo(getXPixel(0), getYPixel(0));
                    c.lineTo(getXPixel(x), getYPixel(y));
                    c.stroke();

                    setTimeout(function check() {
                        c.moveTo(getXPixel(x), getYPixel(y));
                        c.beginPath();
                        c.arc(getXPixel(x), getYPixel(y), 10, 0, 2 * Math.PI);

                        c.stroke();
                        c.fillStyle = "#0000FF";
                        c.fill();
                    }, 400);
                    console.log("start end2");

                });

                ;
                var style = localStorage.getItem('style');
                console.log("circle");

                if (style == "circle") {
                    circle();

                    console.log("end draw 3");

                } else {
                    square();
                };
                event.stopPropagation();
                return false;
            },
        }, '#game_mobilecontainer2 [name="mobileimage_105"]');
        $(document).off("tap", '#game_mobilecontainer2 [name="rank1"]').on({
            tap: function(event) {
                Apperyio.navigateTo('Xappy', {
                    reverse: false
                });
                event.stopPropagation();
                return false;
            },
        }, '#game_mobilecontainer2 [name="rank1"]');

        $(document).off("vclick", '#game_piepopup').on({
            vclick: function(event) {
                Apperyio('piepopup').popup('close');
                Apperyio("rank1").hide();
                Apperyio("rank2").show();
            },
        }, '#game_piepopup');

        $(document).off("vclick", '#game_barpopup').on({
            vclick: function(event) {
                Apperyio('barpopup').popup('close');
                Apperyio("rank2").hide();
                Apperyio("rank3").show();
            },
        }, '#game_barpopup');

        $(document).off("click", '#game_barpopup [name="mobileimage_46"]').on({
            click: function(event) {
                if (!$(this).attr('disabled')) {
                    Apperyio('barpopup').popup('close');

                }
            },
        }, '#game_barpopup [name="mobileimage_46"]');
        $(document).off("vclick", '#game_radialpopup').on({
            vclick: function(event) {
                Apperyio('radialpopup').popup('close');
                Apperyio("rank3").hide();
                Apperyio("rank4").show();
            },
        }, '#game_radialpopup');
        $(document).off("click", '#game_radialpopup [name="mobileimage_48"]').on({
            click: function(event) {
                if (!$(this).attr('disabled')) {
                    Apperyio('radialpopup').popup('close');

                }
            },
        }, '#game_radialpopup [name="mobileimage_48"]');

        $('#game_level').off("panelclose").on("panelclose", function(event) {
            var time = localStorage.getItem('time');
            //var panelskip= localStorage.getItem('panelskip');
            //if (panelskip) {
            //}else{
            if (time == "notime") {} else {
                countdown();
            }
            //};
        });

        $(document).off("tap", '#game_level [name="mobileimage_178"]').on({
            tap: function(event) {
                try {
                    $a.storage["continueyn"].update("$", "yes")
                } catch (e) {
                    console.error(e)
                };
                Apperyio.navigateTo('Xappy', {
                    reverse: false
                });
                resettime();
                try {
                    $a.storage["panelskip"].update("$", "true")
                } catch (e) {
                    console.error(e)
                };
                event.stopPropagation();
                return false;
            },
        }, '#game_level [name="mobileimage_178"]');

        $(document).off("tap", '#game_level [name="notimelabel"]').on({
            tap: function(event) {
                $('[id="game_level"]').panel("close");
                countdown();
                event.stopPropagation();
                return false;
            },
        }, '#game_level [name="notimelabel"]');

    };

    $(document).off("pagebeforeshow", "#game").on("pagebeforeshow", "#game", function(event, ui) {
        Apperyio.CurrentScreen = "game";
        _.chain(Apperyio.mappings).filter(function(m) {
            return m.homeScreen === Apperyio.CurrentScreen;
        }).each(Apperyio.UIHandler.hideTemplateComponents);
    });

    game_onLoad();
};

$(document).off("pagecreate", "#game").on("pagecreate", "#game", function(event, ui) {
    Apperyio.processSelectMenu($(this));
    game_js();
});