var comicNumber = 0;
var latestComic = 0;

function loadComic() {
  var xhr = new XMLHttpRequest({
    mozSystem: true,
    mozAnon: true
  });
  xhr.onload = function(e) {
    if(xhr.status == 200 || xhr.status == 0) {
      var comic = $.parseJSON(xhr.responseText);
      $("#comicTitle").html(comic.title);
      $("#comicTag").attr("src", comic.img);
      $("#comicSubtext").html(comic.alt);
      if(comicNumber == 0) {
        latestComic = comic.num;
      }
      comicNumber = comic.num;
    } else {
      //deal with errors
    }
  };
  var comicURL = "http://xkcd.com/info.0.json";
  if(comicNumber != 0) {
    comicURL = "http://xkcd.com/" + parseInt(comicNumber) + "/info.0.json";
  } else {
    $("#nextButton").attr("disabled", true);
  }
  xhr.open("get", comicURL, true);
  xhr.send();
}

$(function() {
  $("#prevButton").click(function() {
    if(--comicNumber == 404) {
      comicNumber--;
    }
    $("#nextButton").attr("disabled", false);
    loadComic();
  });
  $("#nextButton").click(function() {
    if(++comicNumber == 404) {
      comicNumber++;
    }
    if(comicNumber >= latestComic) {
      $(this).attr("disabled", true);
    }
    loadComic();
  });
  $("#numButton").click(function() {
    var num = prompt("Enter comic number", parseInt(latestComic));
    if(num != null && num != 404) {
      comicNumber = num;
      loadComic();
      if(comicNumber >= latestComic) {
        $("#nextButton").attr("disabled", true);
      } else {
        $("#nextButton").attr("disabled", false);
      }
    } else if(num == 404) {
      alert("No such comic ;)");
    }
  });
  loadComic();
});
