MYASO.Engine = {}

;(function(){	
	function myasoStartLoop(tFrame){
		/* Request page refresh and save it id, to stop it in future*/
		MYASO.Engine.stopMain = window.requestAnimationFrame(myasoStartLoop);
		
		/* Calculate time when rendering must happen */
		var nextRender = MYASO.Engine.lastRender + MYASO.Engine.tickLength;
		
		/* Check is it a time for rendering */		
		if (tFrame > nextRender) {
			/* Time offset for next rendering if pc did not keep up with a rate */
			var timeSinceTick = tFrame - MYASO.Engine.lastRender;
			var numTicks = Math.floor( timeSinceTick / MYASO.Engine.tickLength );
			
			/* Update render to know when we need to draw next time */
			MYASO.Engine.lastRender += numTicks * MYASO.Engine.tickLength;
			
			/* render */
			doRender();
		}
		
		/* Input */
		
		/* Physics */
		doPhysic();
		
		/* Keep track the time points */
		MYASO.Engine.lastTick = tFrame;		
	}
	
	function doRender(){
		for(var i=0;i<MYASO.Engine.renders.length;i++){
			MYASO.Engine.renders[i].draw();
		}
		//console.log("Do render");
	}
	function doPhysic(){
		//console.log("Do physic");
	}
	
	/* Init MYASO.Engine main loop. lastTick is a time point, lastRender store value from requestAnimation frame, tickLength is how often happen rendering */
	MYASO.Engine.lastTick = performance.now();
	MYASO.Engine.lastRender= MYASO.Engine.lastTick;	
	MYASO.Engine.tickLength = 50;
	MYASO.Engine.renders = [];
	MYASO.Engine.addRenders = function(m){
		MYASO.Engine.renders.push(m);
	}
	
	/* Start main loop with passing time point */
	myasoStartLoop(performance.now());	
})();