﻿/**
 * The default storage id for the app.
 */
app.constant('STORAGE_ID', 'xrate_search_history');
/**
 * The ad display depends on this constant. Currently it is disabled.
 */
app.constant('AD_ENABLED', false);
/**
 * AdSense parameters
 * @since 1.1
 */
app.constant('ADSENSE_PARAMETERS', { adClientId : 'ca-pub-3944745263643587', adSlotId : '5667230830', cssStyle : 'display:inline-block;width:320px;height:50px;' });
/**
 * The base url of the source of currency exchange.
 */
app.constant('BASE_URL', 'http://query.yahooapis.com/v1/public/yql?q=select * from yahoo.finance.xchange where pair in ("{1}{2}")&format=json&diagnostics=true&env=store://datatables.org/alltableswithkeys&callback=');
/**
 * The applications default language.
 */
app.constant('DEFAULT_LANGUAGE', 'en');
app.constant('LANGUAGES', [
	{ code : 'en', name : 'English' },
	{ code : 'hu', name : 'Magyar' }
]);
/**
 * This constant contains all translations for the application.
 */
app.constant('LANGUAGE_RESOLVATIONS', {
	'hu.szrnkapeter.xrate:Title' : {
		'hu' : 'XRate valutaváltó',
		'en' : 'XRate currency converter'
	},
	'hu.szrnkapeter.xrate:Exchange' : {
		'hu' : 'Váltás',
		'en' : 'Exchange'
	},
	'hu.szrnkapeter.xrate:History' : {
		'hu' : 'Előzmények',
		'en' : 'History'
	},
	'hu.szrnkapeter.xrate:Settings' : {
		'hu' : 'Beállítások',
		'en' : 'Settings'
	},
	'hu.szrnkapeter.xrate:PlaceholderFrom' : {
		'hu' : 'Forrás valuta',
		'en' : 'From'
	},
	'hu.szrnkapeter.xrate:PlaceholderTo' : {
		'hu' : 'Cél valuta',
		'en' : 'To'
	},
	'hu.szrnkapeter.xrate:Example' : {
		'hu' : 'Példa',
		'en' : 'Example'
	},
	'hu.szrnkapeter.xrate:DeleteAll' : {
		'hu' : 'Összes törlése',
		'en' : 'Delete all'
	},
	'hu.szrnkapeter.xrate:CurrencyExchangeResult' : {
		'hu' : 'Valutaváltás eredménye',
		'en' : 'Currency exchange result'
	},
	'hu.szrnkapeter.xrate:Ask' : {
		'hu' : 'Vétel',
		'en' : 'Ask'
	},
	'hu.szrnkapeter.xrate:Bid' : {
		'hu' : 'Eladás',
		'en' : 'Bid'
	},
	'hu.szrnkapeter.xrate:Switch' : {
		'hu' : 'Csere',
		'en' : 'Switch'
	},
	'hu.szrnkapeter.xrate:Clear' : {
		'hu' : 'Törlés',
		'en' : 'Clear'
	},
	'hu.szrnkapeter.xrate:Save' : {
		'hu' : 'Mentés',
		'en' : 'Save'
	},
	'hu.szrnkapeter.xrate:Ok' : {
		'hu' : 'Rendben',
		'en' : 'Ok'
	},
	'hu.szrnkapeter.xrate:Cancel' : {
		'hu' : 'Mégsem',
		'en' : 'Cancel'
	},
	'hu.szrnkapeter.xrate:ConfirmationTitle' : {
		'hu' : 'Jóváhagyás',
		'en' : 'Confirmation'
	},
	'hu.szrnkapeter.xrate:ConfirmationText' : {
		'hu' : 'Biztos, hogy törölni szeretné az összes előzményt?',
		'en' : 'Are you sure you want to delete all of your currency exchanges?'
	},
	'hu.szrnkapeter.xrate:Loading' : {
		'hu' : 'Betöltés',
		'en' : 'Loading'
	},
	'hu.szrnkapeter.xrate:Details' : {
		'hu' : 'Részletek',
		'en' : 'Details'
	},
	'hu.szrnkapeter.xrate:RepeatSearch' : {
		'hu' : 'Keresés ismétlése',
		'en' : 'RepeatSearch'
	},
	'hu.szrnkapeter.xrate:Delete' : {
		'hu' : 'Törlés',
		'en' : 'Delete'
	},
	'hu.szrnkapeter.xrate:Close' : {
		'hu' : 'Bezárás',
		'en' : 'Close'
	},
	'hu.szrnkapeter.xrate:Language' : {
		'hu' : 'Nyelv',
		'en' : 'Language'
	},
	'hu.szrnkapeter.xrate:FromCurrency' : {
		'hu' : 'Forrás valuta',
		'en' : 'Source currency'
	},
	'hu.szrnkapeter.xrate:ToCurrency' : {
		'hu' : 'Cél valuta',
		'en' : 'Destination currency'
	},
	'hu.szrnkapeter.xrate:Amount' : {
		'hu' : 'Mennyiség',
		'en' : 'Amount'
	},
	'hu.szrnkapeter.xrate:FilterByCurrency' : {
		'hu' : 'Szűrés devizára',
		'en' : 'Filter by currency'
	},
	'hu.szrnkapeter.xrate:FilterPleaseTypeIn' : {
		'hu' : 'Kezdje el beírni a fizetőeszköz nevét vagy rövidítését, pl: USD, Euro.',
		'en' : 'Start typing the name of the currency, e.g.: USD, Euro.'
	}
});
app.constant('CURRENCIES', [
		{ currencyId: "AED", currencyName : "United Arab Emirates Dirham" },
//	{ currencyId: "AFN", currencyName : "Afghanistan Afghani" },
//	{ currencyId: "ALL", currencyName : "Albania Lek" },
//	{ currencyId: "AMD", currencyName : "Armenia Dram" },
	{ currencyId: "ANG", currencyName : "Netherlands Antilles Guilder" },
//	{ currencyId: "AOA", currencyName : "Angola Kwanza" },
	{ currencyId: "ARS", currencyName : "Argentina Peso" },
	{ currencyId: "AUD", currencyName : "Australia Dollar" },
//	{ currencyId: "AWG", currencyName : "Aruba Guilder" },
//	{ currencyId: "AZN", currencyName : "Azerbaijan New Manat" },
//	{ currencyId: "BAM", currencyName : "Bosnia and Herzegovina Convertible Marka" },
//	{ currencyId: "BBD", currencyName : "Barbados Dollar" },
//	{ currencyId: "BDT", currencyName : "Bangladesh Taka" },
	{ currencyId: "BGN", currencyName : "Bulgaria Lev" },
	{ currencyId: "BHD", currencyName : "Bahrain Dinar" },
	{ currencyId: "BIF", currencyName : "Burundi Franc" },
	{ currencyId: "BMD", currencyName : "Bermuda Dollar" },
	{ currencyId: "BND", currencyName : "Brunei Darussalam Dollar" },
	{ currencyId: "BOB", currencyName : "Bolivia Boliviano" },
	{ currencyId: "BRL", currencyName : "Brazil Real" },
	{ currencyId: "BSD", currencyName : "Bahamas Dollar" },
	{ currencyId: "BTN", currencyName : "Bhutan Ngultrum" },
	{ currencyId: "BWP", currencyName : "Botswana Pula" },
	{ currencyId: "BYR", currencyName : "Belarus Ruble" },
	{ currencyId: "BZD", currencyName : "Belize Dollar" },
	{ currencyId: "CAD", currencyName : "Canada Dollar" },
	{ currencyId: "CDF", currencyName : "Congo/Kinshasa Franc" },
	{ currencyId: "CHF", currencyName : "Switzerland Franc" },
	{ currencyId: "CLP", currencyName : "Chile Peso" },
	{ currencyId: "CNY", currencyName : "China Yuan Renminbi" },
	{ currencyId: "COP", currencyName : "Colombia Peso" },
	{ currencyId: "CRC", currencyName : "Costa Rica Colon" },
	{ currencyId: "CUC", currencyName : "Cuba Convertible Peso" },
	{ currencyId: "CUP", currencyName : "Cuba Peso" },
	{ currencyId: "CVE", currencyName : "Cape Verde Escudo" },
	{ currencyId: "CZK", currencyName : "Czech Republic Koruna" },
	{ currencyId: "DJF", currencyName : "Djibouti Franc" },
	{ currencyId: "DKK", currencyName : "Denmark Krone" },
	{ currencyId: "DOP", currencyName : "Dominican Republic Peso" },
	{ currencyId: "DZD", currencyName : "Algeria Dinar" },
	{ currencyId: "EGP", currencyName : "Egypt Pound" },
	{ currencyId: "ERN", currencyName : "Eritrea Nakfa" },
	{ currencyId: "ETB", currencyName : "Ethiopia Birr" },
	{ currencyId: "EUR", currencyName : "Euro Member Countries" },
	{ currencyId: "FJD", currencyName : "Fiji Dollar" },
	{ currencyId: "FKP", currencyName : "Falkland Islands (Malvinas) Pound" },
	{ currencyId: "GBP", currencyName : "United Kingdom Pound" },
	{ currencyId: "GEL", currencyName : "Georgia Lari" },
	{ currencyId: "GGP", currencyName : "Guernsey Pound" },
	{ currencyId: "GHS", currencyName : "Ghana Cedi" },
	{ currencyId: "GIP", currencyName : "Gibraltar Pound" },
	{ currencyId: "GMD", currencyName : "Gambia Dalasi" },
	{ currencyId: "GNF", currencyName : "Guinea Franc" },
	{ currencyId: "GTQ", currencyName : "Guatemala Quetzal" },
	{ currencyId: "GYD", currencyName : "Guyana Dollar" },
	{ currencyId: "HKD", currencyName : "Hong Kong Dollar" },
	{ currencyId: "HNL", currencyName : "Honduras Lempira" },
	{ currencyId: "HRK", currencyName : "Croatia Kuna" },
	{ currencyId: "HTG", currencyName : "Haiti Gourde" },
	{ currencyId: "HUF", currencyName : "Hungary Forint" },
	{ currencyId: "IDR", currencyName : "Indonesia Rupiah" },
	{ currencyId: "ILS", currencyName : "Israel Shekel" },
	{ currencyId: "IMP", currencyName : "Isle of Man Pound" },
	{ currencyId: "INR", currencyName : "India Rupee" },
	{ currencyId: "IQD", currencyName : "Iraq Dinar" },
//	{ currencyId: "IRR", currencyName : "Iran Rial" },
	{ currencyId: "ISK", currencyName : "Iceland Krona" },
	{ currencyId: "JEP", currencyName : "Jersey Pound" },
	{ currencyId: "JMD", currencyName : "Jamaica Dollar" },
	{ currencyId: "JOD", currencyName : "Jordan Dinar" },
	{ currencyId: "JPY", currencyName : "Japan Yen" },
	{ currencyId: "KES", currencyName : "Kenya Shilling" },
	{ currencyId: "KGS", currencyName : "Kyrgyzstan Som" },
	{ currencyId: "KHR", currencyName : "Cambodia Riel" },
	{ currencyId: "KMF", currencyName : "Comoros Franc" },
	{ currencyId: "KPW", currencyName : "Korea (North) Won" },
	{ currencyId: "KRW", currencyName : "Korea (South) Won" },
	{ currencyId: "KWD", currencyName : "Kuwait Dinar" },
	{ currencyId: "KYD", currencyName : "Cayman Islands Dollar" },
	{ currencyId: "KZT", currencyName : "Kazakhstan Tenge" },
	{ currencyId: "LAK", currencyName : "Laos Kip" },
	{ currencyId: "LBP", currencyName : "Lebanon Pound" },
	{ currencyId: "LKR", currencyName : "Sri Lanka Rupee" },
	{ currencyId: "LRD", currencyName : "Liberia Dollar" },
	{ currencyId: "LSL", currencyName : "Lesotho Loti" },
	{ currencyId: "LTL", currencyName : "Lithuania Litas" },
	{ currencyId: "LVL", currencyName : "Latvia Lat" },
	{ currencyId: "LYD", currencyName : "Libya Dinar" },
	{ currencyId: "MAD", currencyName : "Morocco Dirham" },
	{ currencyId: "MDL", currencyName : "Moldova Leu" },
	{ currencyId: "MGA", currencyName : "Madagascar Ariary" },
	{ currencyId: "MKD", currencyName : "Macedonia Denar" },
	{ currencyId: "MMK", currencyName : "Myanmar (Burma) Kyat" },
	{ currencyId: "MNT", currencyName : "Mongolia Tughrik" },
	{ currencyId: "MOP", currencyName : "Macau Pataca" },
	{ currencyId: "MRO", currencyName : "Mauritania Ouguiya" },
	{ currencyId: "MUR", currencyName : "Mauritius Rupee" },
	{ currencyId: "MVR", currencyName : "Maldives (Maldive Islands) Rufiyaa" },
	{ currencyId: "MWK", currencyName : "Malawi Kwacha" },
	{ currencyId: "MXN", currencyName : "Mexico Peso" },
	{ currencyId: "MYR", currencyName : "Malaysia Ringgit" },
	{ currencyId: "MZN", currencyName : "Mozambique Metical" },
	{ currencyId: "NAD", currencyName : "Namibia Dollar" },
	{ currencyId: "NGN", currencyName : "Nigeria Naira" },
	{ currencyId: "NIO", currencyName : "Nicaragua Cordoba" },
	{ currencyId: "NOK", currencyName : "Norway Krone" },
	{ currencyId: "NPR", currencyName : "Nepal Rupee" },
	{ currencyId: "NZD", currencyName : "New Zealand Dollar" },
	{ currencyId: "OMR", currencyName : "Oman Rial" },
	{ currencyId: "PAB", currencyName : "Panama Balboa" },
	{ currencyId: "PEN", currencyName : "Peru Nuevo Sol" },
	{ currencyId: "PGK", currencyName : "Papua New Guinea Kina" },
	{ currencyId: "PHP", currencyName : "Philippines Peso" },
	{ currencyId: "PKR", currencyName : "Pakistan Rupee" },
	{ currencyId: "PLN", currencyName : "Poland Zloty" },
	{ currencyId: "PYG", currencyName : "Paraguay Guarani" },
	{ currencyId: "QAR", currencyName : "Qatar Riyal" },
	{ currencyId: "RON", currencyName : "Romania New Leu" },
	{ currencyId: "RSD", currencyName : "Serbia Dinar" },
	{ currencyId: "RUB", currencyName : "Russia Ruble" },
	{ currencyId: "RWF", currencyName : "Rwanda Franc" },
	{ currencyId: "SAR", currencyName : "Saudi Arabia Riyal" },
	{ currencyId: "SBD", currencyName : "Solomon Islands Dollar" },
	{ currencyId: "SCR", currencyName : "Seychelles Rupee" },
	{ currencyId: "SDG", currencyName : "Sudan Pound" },
	{ currencyId: "SEK", currencyName : "Sweden Krona" },
	{ currencyId: "SGD", currencyName : "Singapore Dollar" },
	{ currencyId: "SHP", currencyName : "Saint Helena Pound" },
	{ currencyId: "SLL", currencyName : "Sierra Leone Leone" },
	{ currencyId: "SOS", currencyName : "Somalia Shilling" },
	{ currencyId: "SPL*", currencyName : "Seborga Luigino" },
	{ currencyId: "SRD", currencyName : "Suriname Dollar" },
	{ currencyId: "STD", currencyName : "São Tomé and Príncipe Dobra" },
	{ currencyId: "SVC", currencyName : "El Salvador Colon" },
	{ currencyId: "SYP", currencyName : "Syria Pound" },
	{ currencyId: "SZL", currencyName : "Swaziland Lilangeni" },
	{ currencyId: "THB", currencyName : "Thailand Baht" },
	{ currencyId: "TJS", currencyName : "Tajikistan Somoni" },
	{ currencyId: "TMT", currencyName : "Turkmenistan Manat" },
	{ currencyId: "TND", currencyName : "Tunisia Dinar" },
	{ currencyId: "TOP", currencyName : "Tonga Pa'anga" },
	{ currencyId: "TRY", currencyName : "Turkey Lira" },
	{ currencyId: "TTD", currencyName : "Trinidad and Tobago Dollar" },
	{ currencyId: "TVD", currencyName : "Tuvalu Dollar" },
	{ currencyId: "TWD", currencyName : "Taiwan New Dollar" },
	{ currencyId: "TZS", currencyName : "Tanzania Shilling" },
	{ currencyId: "UAH", currencyName : "Ukraine Hryvna" },
	{ currencyId: "UGX", currencyName : "Uganda Shilling" },
	{ currencyId: "USD", currencyName : "United States Dollar" },
	{ currencyId: "UYU", currencyName : "Uruguay Peso" },
	{ currencyId: "UZS", currencyName : "Uzbekistan Som" },
	{ currencyId: "VEF", currencyName : "Venezuela Bolivar" },
	{ currencyId: "VND", currencyName : "Viet Nam Dong" },
//	{ currencyId: "VUV", currencyName : "Vanuatu Vatu" },
//	{ currencyId: "WST", currencyName : "Samoa Tala" },
//	{ currencyId: "XAF", currencyName : "Communauté Financière Africaine (BEAC) CFA Franc BEAC" },
//	{ currencyId: "XCD", currencyName : "East Caribbean Dollar" },
//	{ currencyId: "XDR", currencyName : "International Monetary Fund (IMF) Special Drawing Rights" },
//	{ currencyId: "XOF", currencyName : "Communauté Financière Africaine (BCEAO) Franc" },
//	{ currencyId: "XPF", currencyName : "Comptoirs Français du Pacifique (CFP) Franc" },
	{ currencyId: "YER", currencyName : "Yemen Rial" },
	{ currencyId: "ZAR", currencyName : "South Africa Rand" },
//	{ currencyId: "ZMW", currencyName : "Zambia Kwacha" },
//	{ currencyId: "ZWD", currencyName : "Zimbabwe Dollar" }
]);