// The watch id references the current `watchAcceleration`
var aSensor = null;

/**
 * ページ初期化が行われた時に実行します。
 */
$(document).bind('mobileinit', function(){
  $.mobile.defaultPageTransition = 'none';  
});

/**
* FastClickイベントの初期化処理。
*/
window.addEventListener('load', function() {
    FastClick.attach(document.body);
}, false);

/**
 * ホームタブが押下された時に実行します。
 */
// tappable('#homeTab', function (e, target) {
//     $("body").pagecontainer("change", "#home");
//     // $("body").pagecontainer("change", "#home", {transition: "slide"});
// });

/**
 * 設定タブが押下された時に実行します。
 */
// tappable('#settingsTab', function (e, target) {
//     $("body").pagecontainer("change", "#settings");
// });

$(function () {
    $('#select-choice-in').bind('change', function() {
        var data = $(this).val();
//      alert('入力リストの値は「' + data + '」です');
//        選択している言語を変更した場合のみ入力・出力テキストの初期化
$('#inputText').val('');
$('#outputText').val('');
saveData(INPUT, data);
});
});

/**
 * 出力言語が変更された場合に呼び出されます。
 */
 $(function () {
    $('select#select-choice-out').change(function () {
        var data = $(this).val();
        //        選択している言語を変更した場合のみ出力テキストの初期化
        $('#outputText').val('');
        saveData(OUTPUT, data);

if (inputText.value != ""){
        translateLogic(inputText.value);
}

if (device.platform == 'Android') {

        // TTS音声言語の実行(出力言語で選択されているものを設定)
        // window.plugins.tts.setLanguage(data, ttsSetlangSuccess, ttsSetlangFail);
        initTts();
    }
});
});


/**
 * センサー利用チェックボックスが選択された場合に呼び出されます。
 */
 $(function () {
    $('select#useSensor').change(function () {
        var isChecked = jQuery(this).val();
        saveData(USESENSOR, isChecked);
    });
});

/**
 * NWチェック利用チェックボックスが選択された場合に呼び出されます。
 */
 $(function () {
    $('select#useNwCheck').change(function () {
        var isChecked = jQuery(this).val();
        saveData(USENWCHECK, isChecked);
    });
});

/**
 * PhoneGapの初期化処理を行います。
 */
 function init() {
    console.log("***init()-Start");
    // alert("***init()-Start");
    // PhoneGap初期化処理
    document.addEventListener("deviceready", onDeviceReady, false);
    // BackButton処理 (Tizen以外)
    document.addEventListener("backbutton", onBackPressed, false);
    // backkey制御 (Tizen)
    document.addEventListener('tizenhwkey', function(e) {
    if (e.keyName == "back")
        tizen.application.getCurrentApplication().exit();
    });
}

/**
 * バックキーが押された場合の処理です。
 */
 function onBackPressed() {
    // 終了確認ダイアログを表示します。
    //navigator.notification.confirm("Do you want to Quit?", confirmCallback, 'Confirm', 'Cancel, Quit');
    // 即終了
    navigator.app.exitApp();
}

/**
 * 終了確認ダイアログの実装です。
 */
 /*
 function confirmCallback(id) {
    // ダイアログでQuitが選択された場合
    if (id == 2) {
        // for Android
        navigator.app.exitApp();
    }
}
*/


/**
 * PhoneGapの初期化処理が完了した時に呼び出されます。
 */
 function onDeviceReady() {
    // 加速度の測定開始
    startWatch();
    // console.log('device.platform=' + device.platform);
    
    // TTSエンジンの初期化
    // navigator.tts.startup(initTtsSuccess, initTtsFailure);
    // window.plugins.tts.startup(initTtsSuccess, initTtsFail);
    initTts();

    if( device.platform == "iOS" ){
        StatusBar.overlaysWebView(false);
        // console.log("Run StatusBar.overlaysWebView");
    }
}

/**
* TTSの設定を行います。
*/
function initTts() {
    // Androidの場合のみ、表示
    if (device.platform == 'Android') {
        $('#buttonVoiceInput').show();
        $('#buttonVoiceOutput').show();
//        $('#buttonVoiceOutput').button('disable');
//        $('#buttonVoiceOutput').button('refresh');
        // ボタン無効化
        // jQuery('#buttonVoiceOutput').disabled(true);
    } else {
        $('#buttonVoiceInput').hide();
        $('#buttonVoiceOutput').hide();
    }

    if ($('select#select-choice-out').val() == 'ja'){
            $('#buttonVoiceOutput').hide();
    }
}

/**
 * [OLD]TTSエンジンの初期化が成功した時に呼ばれます。
 *
 * @param result 処理結果
 */
//  function initTtsSuccess(result) {
//     // When result is equal to STARTED we are ready to play
//     if (result == TTS.STARTED) {
//         console.log('Success on TTS init.');
//         // 日本語の音声出力はできないため、無効化
//         if ($('select#select-choice-out').val() == 'ja'){
//             $('#buttonVoiceOutput').hide();
//         }

//         // TTS音声言語の設定(出力言語で選択されているものを設定する。設定不可の場合は音声出力ボタンを利用不可に)
//         window.plugins.tts.isLanguageAvailable($('select#select-choice-out').val(), function () {
//             console.log('Available');
//             window.plugins.tts.setLanguage($('select#select-choice-out').val(), ttsSetlangSuccess, ttsSetlangFail);
//         }, ttsIsLangNotAvailable);
//     }
// }

/**
 * [OLD]TTSエンジンの初期化が失敗した時に呼ばれます。
 *
 * @param result 処理結果
 */
//  function initTtsFailure(result) {
//     console.log("Fail on TTS init.");
// }

/**
 * [OLD]TTSの言語設定が失敗した時に呼ばれます。
 *
 * @param result 処理結果
 */
//  function ttsIsLangNotAvailable(result) {
//     console.log("Not Available this lang");
//     $('#buttonVoiceOutput').hide();
// }

/**
 * [OLD]TTSの言語設定が成功した時に呼ばれます。
 *
 * @param result 処理結果
 */
//  function ttsSetlangSuccess(result) {
//     console.log("Success on TTS setLang.");
// }

/**
 * [OLD]TTSの言語設定が失敗した時に呼ばれます。
 *
 * @param result 処理結果
 */
//  function ttsSetlangFail(result) {
//     console.log("Fail on TTS setLang.");
// }

/**
 * 加速度の測定を開始します。
 */
 function startWatch() {
    // 加速度センサー取得間隔(0.5sec)
    var options = { frequency: 500 };
    aSensor = navigator.accelerometer.watchAcceleration(onAccelerationSuccess, onAccelerationError, options);
}

/**
 * 加速度の測定を停止します。
 */
 function stopWatch() {
    // 加速度のインスタンスが生成されている場合のみ
    if (aSensor) {
        navigator.accelerometer.clearWatch(aSensor);
        aSensor = null;
    }
}

var currentOrientation = ['0.0', '0.0', '0.0'];
var currentAcceleration = ['0.0', '0.0', '0.0'];


/**
 * 加速度の取得に成功した場合に呼び出されます。
 *
 * @param values 加速度の値の配列([0]x軸[1]y軸[2]z軸)
 */
 function onAccelerationSuccess(values) {
    // 傾き（ハイカット）
    currentOrientation[0] = values.x * 0.1 + currentOrientation[0] * 0.9;
    currentOrientation[1] = values.y * 0.1 + currentOrientation[1] * 0.9;
    currentOrientation[2] = values.z * 0.1 + currentOrientation[2] * 0.9;
    // 加速度（ローカット）
    currentAcceleration[0] = values.x - currentOrientation[0];
    currentAcceleration[1] = values.y - currentOrientation[1];
    currentAcceleration[2] = values.z - currentOrientation[2];
//            console.log("ax=" + currentAcceleration[0] + ",ay=" + currentAcceleration[1] + ",az=" + currentAcceleration[2]);
    // 振ってるいるかの判定
    var targetValue =
    Math.abs(currentAcceleration[0]) +
    Math.abs(currentAcceleration[1]) +
    Math.abs(currentAcceleration[2]);
    // 加速度が一定以上、かつ、設定でセンサー連携が有効になっている場合のみ
    if ((targetValue > 13.0) && (loadData(USESENSOR) == 'true')) {
        console.log('do Translatte');
        translateLogic(inputText.value);
    }
}

/**
 * 加速度取得に失敗した場合の処理を行います。
 */
 function onAccelerationError() {
    console.log('Cannot use Accelemeter');
}

const INPUT = 'in';
const OUTPUT = 'out';
const USESENSOR = 'useSensor';
const USENWCHECK = 'useNwCheck';
$(document).ready(function () {
    // ページ読み込み時に実行したい処理
    var selectInput = $('select#select-choice-in');
    selectInput[0].value = loadData(INPUT);
    selectInput.selectmenu("refresh");
    var selectOutput = $('select#select-choice-out');
    selectOutput[0].value = loadData(OUTPUT);
    selectOutput.selectmenu("refresh");
    // // センサー利用有無
    // var switchSensor = $('select#useSensor');
    // switchSensor[0].value = loadData(USESENSOR);
    // // NWチェック利用有無
    // var switchNwCheck = $('select#useNwCheck');
    // switchNwCheck[0].value = loadData(USENWCHECK);
    // センサー利用有無
$("select#useSensor").val(loadData(USESENSOR)).flipswitch("refresh");
// NWチェック利用有無
$("select#useNwCheck").val(loadData(USENWCHECK)).flipswitch("refresh");
});

/**
 * 入力エリアにテキストを設定します。
 *
 * @param text テキスト
 */
 function setInputText(text) {
    $('#inputText').val(text);
    // document.getElementById("inputText").value = text;
};

/**
 * 出力エリアにテキストを設定します。
 *
 * @param text テキスト
 */
 function setOutputText(text) {
    $('#outputText').val(text);
    // document.getElementById("outputText").value = text;
};


/**
 * キーと値の組をストレージに保存します。
 *
 * @param key キー
 * @param value 値
 */
 function saveData(key, value) {
    console.log('saveData');
    window.localStorage.setItem(key, value);
};

/**
 * 指定したキーにひもづく値をストレージから取得します。
 *
 * @param key キー
 * @returns {*} 値
 */
 function loadData(key) {
    var ret = window.localStorage.getItem(key);
    console.log('loadData');
    // alert("loadData:key=" + key + ",ret=" + ret);
    if (ret == null) {
        if (key == INPUT) {
            ret = 'en';
        } else if (key == OUTPUT) {
            ret = 'de';
        } else if (key == USESENSOR) {
            ret = 'true';
        } else if (key == USENWCHECK) {
            ret = 'true';
        }
    }
    return ret;
};

/**
* アラートダイアログを表示します。
*/
function showAlertDialog(content){
    navigator.notification.alert(
            content,  // message
            doNothing,  // callback
            'Alert',    // title
            'OK'        // buttonName
    );
};

function doNothing() {
    console.log('do nothing');
};