/**
 * 音声入力ボタンが押下された時に実行します。
 */
//  tappable('#buttonVoiceInput', function (e, target) {
//     console.log('@@@VoiceInput');
// //    alert('@@@VoiceInput');
// recognizeSpeech($('select#select-choice-in').val());
// })
$('#buttonVoiceInput').fastClick(function() {
  recognizeSpeech($('select#select-choice-in').val());
});

/**
 * 音声出力ボタンが押下された時に実行します。
 */
// tappable('#buttonVoiceOutput', function (e, target) {
//     console.log('@@@VoiceOutput');
// //    alert('@@@VoiceInput');
// voiceSpeech(outputText.value, $('select#select-choice-out').val());
// })
$('#buttonVoiceOutput').fastClick(function() {
  voiceSpeech(outputText.value, $('select#select-choice-out').val());
});

/**
 * 音声出力を行います。
 *
 * @param text テキスト
 * @param language 言語コード(en,de等)
 */
 function voiceSpeech(text, language) {
    console.log('text=' + text + ',language=' + language);
    // テキスト未入力の場合、エラーダイアログを表示し、以後の処理を行わない。
    if (text == "") {
        showAlertDialog('No Text to read.');
        return;
    }

    // window.plugins.tts.speak(text, language);
    // window.plugins.tts.speak(text, ttsSuccess, ttsFailure);

    var u = new SpeechSynthesisUtterance();
    u.text = text;
    // u.lang = 'en-US';
    u.lang = language;
    speechSynthesis.speak(u);
}

function ttsSuccess(result) {
    console.log("ttsSuccess: " + result.toString());
}

function ttsFailure(result) {
    console.log("ttsFailure: " + result.toString());
}

/**
 * 音声入力を行います。
 *
 * @param language 言語コード(en,de等)
 */
 function recognizeSpeech(language) {
    // var requestCode = 1234;
    var maxMatches = 1;
    var promptString = "Please speak.";
    window.plugins.speechrecognizer.startRecognize(speechSuccess, speechFailure,
        maxMatches, promptString, language);

    // for debug
//    speechSuccess('pistol,distal,crystal,Tiesto');
}

/**
 * 音声認識が成功した場合の処理です。
 *
 * @param result 認識結果(カンマ区切りの文字列(例'a,b,c'))
 */
 function speechSuccess(result) {
    var match, respObj, requestCode;
    //console.log('@@@speechOk:result=' + result);
    setInputText(result);
    setOutputText('');
//    alert('@@@speechOk:result=' + result);
    /*
    if (result) {
        //alert('result = !null');
        var resArray = result.split(",");
        alert('@@@text=' + resArray);
//        var ret = "";
//        for (var i = 0; i < resArray.length; i++) {
//            ret += resArray[i] + "\n";
//        }
        setInputText(resArray[0]);
    }
    */
}

/**
 *
 * 音声認識が失敗した場合の処理です。
 *
 * @param m 処理結果
 */
 function speechFailure(m) {
    console.log("speechFail: " + m.toString());
}