function CanvasManager(id, gridW, gridH, innerWidth, innerHeight, maxW, maxH, handlerStart) {
    this.id = id;
    this.canvas = $(id).get(0);
    this.gridW = gridW;
    this.gridH = gridH;
    this.maxW = maxW;
    this.maxH = maxH;
    this.context = $(id).get(0).getContext("2d");
    //Inicializacion
    this.canvas.height = innerHeight;
    this.canvas.width = innerWidth;
    this.height = innerHeight;
    this.width = innerWidth;
    //Adjust canvas element to container
    this.enable = true;
    this.canvas.addEventListener("touchstart", handlerStart, false);
    //this.canvas.addEventListener("touchend", handleEnd, false);
    //this.canvas.addEventListener("touchcancel", handleCancel, false);
    //this.canvas.addEventListener("touchleave", handleLeave, false);
    //this.canvas.addEventListener("touchmove", handleMove, false);
    this.resize();
    //ENABLES DISABLES
    this.enVibrate = true;
    this.enSounds = true;
}
CanvasManager.prototype.drawText = function(x, y, text) {
    try {
        this.context.save();
        this.context.fillStyle = "black";
        this.context.font = "bold 24px arial";
        this.context.fillText(text + "", x, y);
        this.context.restore();
    } catch (E) {
        //console.log(E);
    }
};
CanvasManager.prototype.drawScore = function(text) {
    try {
        this.context.save();
        this.context.fillStyle = "black";
        this.context.font = "bold 16px fingerFontWoff";
        this.context.fillText(text + "", 10, 20);
        this.context.restore();
    } catch (E) {
        //console.log(E);
    }
};
CanvasManager.prototype.enableVibrate = function() {
    this.enVibrate = true;
};
CanvasManager.prototype.disableVibrate = function() {
    this.enVibrate = false;
};
CanvasManager.prototype.setVibrate = function(val) {
    if (val === "true") {
        //console.log("->true");
        this.enVibrate = true;
    } else {
        //console.log("->false");
        this.enVibrate = false;
    }
};
CanvasManager.prototype.setplayChanel = function(val) {
    if (val === "true") {
        this.enSounds = true;
    } else {
        this.enSounds = false;
    }
};
CanvasManager.prototype.vibrate = function() {
    try {
        if (this.enVibrate) {
            window.navigator.vibrate(100);
        }
    } catch (E) {
        //console.log(E);
    }
};
CanvasManager.prototype.enableplayChanel = function() {
    this.enSounds = true;
};
CanvasManager.prototype.disableplayChanel = function() {
    this.enSounds = false;
};

CanvasManager.prototype.playChanel = function(selector) {
    if (this.enSounds) {
        try {
            $(selector).get(0).currentTime = 0;
            $(selector).get(0).play();
        } catch (E) {
            //console.log(E);
        }
    }
};
CanvasManager.prototype.playRateChange = function(selector, speed) {
    $(selector).get(0).playbackRate = speed;
};
CanvasManager.prototype.resize = function() {
    var rW = this.maxW / this.width;
    var rH = this.maxH / this.height;
    if ((rW < 1 || rH < 1) && rW < rH) {
        $(this.canvas).css("width", this.width * rW);
        $(this.canvas).css("height", this.height * rW);
    } else if (rW < 1 || rH < 1) {
        $(this.canvas).css("width", this.width * rH);
        $(this.canvas).css("height", this.height * rH);
    } else {
        $(this.canvas).css("width", this.width);
        $(this.canvas).css("height", this.height);
    }
};
CanvasManager.prototype.clear = function() {
    this.context.clearRect(0, 0, $(this.id).get(0).width, $(this.id).get(0).height);
};
CanvasManager.prototype.draw = function(sprite) {
    this.context.save();
    sprite.draw(this.context);
    this.context.restore();
};
