function DataManager() {
    this.isMusic = true;
    this.isEffet = true;
    this.isAsisted = true;
    this.isVibrate = true;
    this.lang = 'es';
    this.modoArcade = new Array();
    this.modoPalabra = new Array();
    for (var i = 0; i < localStorage.length; i++) {
        var key = localStorage.key(i);
        var val = localStorage.getItem(key);
        if (key !== "") {
            if (key == 'music') {
                this.isMusic = val;
            } else if (key == 'effect') {
                this.isEffet = val;
            } else if (key == "asisted") {
                this.isAsisted = val;
            } else if (key == 'vibrate') {
                this.isVibrate = val;
            } else if (key == 'lang') {
                this.lang = val;
            }
        } else {
            //console.log("Es un higscore");
            if (val[3] == 0) {
                this.modoArcade.push([key, val]);
            } else {
                this.modoPalabra.push([key, val]);
            }
        }
    }
    this.listAll();
}
//Nombre:[score,fails,time,game]
DataManager.prototype.loadOptions = function(musicInput, effectInput, isAsistedInput, isVibrateInput) {
    $(musicInput).attr("checked", this.isMusic);
    $(effectInput).attr("checked", this.isEffet);
    $(isAsistedInput).attr("checked", this.isAsisted);
    $(isVibrateInput).attr("checked", this.isVibrate);
};
DataManager.prototype.setMusic = function(val) {
    if (val === "true") {
        this.isMusic = true;
    } else {
        this.isMusic = false;
    }
};
DataManager.prototype.setVibrate = function(val) {
    if (val === "true") {
        this.isVibrate = true;
    } else {
        this.isVibrate = false;
    }
};
DataManager.prototype.setEffect = function(val) {
    if (val == 'true') {
        this.isEffet = true;
    } else {
        this.isEffet = false;
    }
};
DataManager.prototype.setAsisted = function(val) {
    if (val == 'true') {
        this.isAsisted = true;
    } else {
        this.isAsisted = false;
    }
};
DataManager.prototype.getModo1 = function() {
    return this.modoArcade;
};
DataManager.prototype.getModo2 = function() {
    return this.modoPalabra;
};
DataManager.prototype.listAll = function() {
    console.log("++++++++++++++OPTIONS+++++++++++++");
    console.log("music: " + this.isMusic);
    console.log("effect: " + this.isEffet);
    console.log("vibrate: " + this.isVibrate);
    console.log("asisted: " + this.isAsisted);
    console.log("lang: " + this.lang);
    console.log("++++++++++++++SCORES+++++++++++++");
    for (i = 0; i < this.modoArcade.length; i++) {
        console.log("Nombre:" + this.modoArcade[i][0] + " score:" + this.modoArcade[i][1][0] + " fail:" + this.modoArcade[i][1][1] + " time:" + this.modoArcade[i][1][2] + " game:" + this.modoArcade[i][1][3]);
    }
    for (i = 0; i < this.modoPalabra.length; i++) {
        console.log("Nombre:" + this.modoPalabra[i][0] + " score:" + this.modoPalabra[i][1][0] + " fail:" + this.modoPalabra[i][1][1] + " time:" + this.modoPalabra[i][1][2] + " game:" + this.modoPalabra[i][1][3]);
    }
    console.log("+++++++++++++++++++++++++++++++++");
};
DataManager.prototype.add = function(name, score, fails, time, modo) {
    if (modo == 0) {
        this.modoArcade.push([name, [score, fails, time, modo]]);
        this.modoArcade.sort(function(a, b) {
            if (b[1][0] === a[1][0]) {
                if (b[1][1] === a[1][1]) {
                    return a[1][2] - b[1][2];
                }
                return a[1][1] - b[1][1];
            }
            return b[1][0] - a[1][0];
        });
        this.modoArcade = this.modoArcade.slice(0, 10);
    } else {
        this.modoPalabra.push([name, [score, fails, time, modo]]);
        this.modoPalabra.sort(function(a, b) {
            if (b[1][0] === a[1][0]) {
                if (b[1][1] === a[1][1]) {
                    return a[1][2] - b[1][2];
                }
                return a[1][1] - b[1][1];
            }
            return b[1][0] - a[1][0];
        });
        this.modoPalabra = this.modoPalabra.slice(0, 10);
    }
    this.save();
};
DataManager.prototype.save = function() {
    localStorage.clear();
    localStorage.setItem("music", this.isMusic);
    localStorage.setItem("effect", this.isEffet);
    localStorage.setItem("vibrate", this.isVibrate);
    localStorage.setItem("asisted", this.isAsisted);
    localStorage.setItem("lang", this.lang);
    for (var i = 0; i < this.modoArcade.length; i++) {
        localStorage.setItem(this.modoArcade[i][0], this.modoArcade[i][1]);
    }
    for (var i = 0; i < this.modoPalabra.length; i++) {
        localStorage.setItem(this.modoPalabra[i][0], this.modoPalabra[i][1]);
    }
};