function Sprite(src, width, height, framesH, framesV, initX, initY, framesRelation, scaleX, scaleY, colisionRadius) {
    //Atributes
    this.img = new Image();
    this.width = width;
    this.height = height;
    this.framesH = framesH;
    this.framesV = framesV;
    this.x = initX;
    this.y = initY;
    this.scaleX = scaleX;
    this.scaleY = scaleY;
    this.colisionRadius = colisionRadius;
    this.currentImgFrame = 0;
    this.currentFrameV = 0;
    this.ImgFramesPerFrame = framesRelation;
    //Inner variables
    this.framesCount = 0;
    this.mustDie = false;
    this.isAlive = true;
    this.lifeTime = -1;
    //Resource loading
    this.img.src = src;
    this.isPlaying = false;
}
Sprite.prototype.stopAnim = function() {
    this.isPlaying = false;
};
Sprite.prototype.playAnim = function() {
    this.isPlaying = true;
};
Sprite.prototype.requestAnim = function(animNum) {
    if (animNum < this.framesV && animNum >= 0) {
        this.currentFrameV = animNum;
    }
};
Sprite.prototype.requestAnimAndDie = function(animNum) {
    if (animNum < this.framesV && animNum >= 0) {
        this.currentFrameV = animNum;
        this.mustDie = true;
        this.currentImgFrame = 0;
    }
};
Sprite.prototype.update = function() {
    if (!this.mustDie) {
        if (this.isPlaying) {
            if (this.framesCount >= this.ImgFramesPerFrame) {
                this.currentImgFrame++;
                if (this.currentImgFrame >= this.framesH) {
                    this.currentImgFrame = 0;
                }
                this.framesCount = 0;
            }
            this.framesCount++;
        }
    } else {
        if (this.framesCount >= this.ImgFramesPerFrame) {
            this.currentImgFrame++;
            if (this.currentImgFrame >= this.framesH) {
                this.isAlive = false;
            }
        }
        this.framesCount++;
    }
};
Sprite.prototype.draw = function(g) {
    if (this.isAlive) {
        g.drawImage(this.img, this.width * this.currentImgFrame, this.currentFrameV * this.height, this.width, this.height, this.x, this.y, this.scaleX, this.scaleY);
    }
};
Sprite.prototype.isColiding = function(pointX, pointY) {
    var x, y;
    x = this.x - pointX + this.scaleX / 2;
    y = this.y - pointY + this.scaleY / 2;
    var d = Math.sqrt(x * x + y * y);
    if (d <= this.colisionRadius) {
        return true;
    }
    return false;
};