function Controller(num_players, start_player)
{
	var _viewGame = new VisualGame(this)
	var _viewInterface = new VisualInterface(this, num_players)
	var _viewTutorial = new VisualTutorial(this)
	var _viewPopup = new VisualPopupText(this)
	var _logic = new LogicGame()

	_viewTutorial.visible = false

	setObservers()
	if(st_getNumPlay() == 1){
		_viewTutorial.visible = true
		_logic.setPopUp("text_tap_to_play")
	}

//-- InterFace for VisualGame
	this.tapOnRoll = function(){
		_logic.rollDice()
	}

	this.tapOnDice = function(v){
		_logic.holdDice(v)
	}

	this.tapOnCell = function(i, j){
		if(typeof(i) != "number" || typeof(j) != "number")
			return
		if(j == 1)
			return
		_logic.setScore(i, j)
	}

	this.gameOver = function(w){
		// console.log("gameOver", w)
		t_delayOn(2, function(){
			openWindow("gameOver", {num_p: num_players, winner: w.winner, user_score: w.user_score, opo_score: w.opo_score, best_score: w.best_score, best: w.best})
		})
	}
//------------------------------//
//-- InterFace for VisualInterface
	this.tapOnHome = function(){
		// openWindow("gameOver", {num_p: 2, winner: "user", user_score: 44, opo_score: 22, best_score: 13, best: false})
		openWindow("ayr", {par: "game", par_ret: {dont_update: true}})
	}

	this.tapOnSetting = function(){
		openWindow("setting", {par: "game"})
	}
//------------------------------//
//-- Interface for VisualTutorial
	this.showHints = function(){
		_viewTutorial.visible = true
	}

	this.hideHints = function(){
		_viewTutorial.visible = false
	}

	this.tapOnHints = function(){
		_logic.nextHint()
	}
//------------------------------//

// --- Getters ---- //
	this.getVisual = function(){
		var cont = new createjs.Container()
		cont.addChild(_viewGame)
		cont.addChild(_viewInterface)
		cont.addChild(_viewPopup)
		cont.addChild(_viewTutorial)

		return cont
	}

	_logic.init(num_players, start_player)
//-------PRIVATE--------//
	function setObservers(){
		_logic.registerObserveToGame(_viewGame)
		_logic.registerObserveToInterface(_viewInterface)
		_logic.registerObserveToTutorial(_viewTutorial)
		_logic.registerObserveToPopup(_viewPopup)
	}

	function openWindow(wnd, par){
		t_allInPause()
		v_choiseLocation(wnd, par)
	}
}