function importScript(url)
{
	var script = document.createElement('script');
	script.src = "src/" + url;
	document.head.appendChild(script);
}

function extend(Child, Parent) {

	var F = function() { }

	F.prototype = Parent.prototype

	Child.prototype = new F()

	Child.prototype.constructor = Child

	Child.superclass = Parent.prototype
}

function dragAndDrop(o, callUp, callDown, callMome, objects, scale){
	var dx;
	var dy;
	var sc = scale ? scale : 1
	var ob_coor = new Array()
	o.addEventListener("mousedown", function(e){
											// console.log(sc)
											dx = (e.stageX - e.target.x);
											dy = (e.stageY - e.target.y);
											if(objects)
												for(var a=0; a<objects.length; a++){
													var ob = {dx: e.stageX - objects[a].x, dy: e.stageY - objects[a].y}
													ob_coor[a] = ob
												}
											if(callDown)
												callDown()
										});
	o.addEventListener("pressmove", function(e){
											e.target.x = e.stageX - dx;
											e.target.y = e.stageY - dy;
											if(objects)
												for(var a=0; a<objects.length; a++){
													objects[a].x = e.stageX - ob_coor[a].dx
													objects[a].y = e.stageY - ob_coor[a].dy
												}
											if(callMome)
												callMome()
										});
	o.addEventListener('pressup', function(e){
		if(callUp)
			callUp.apply(null, [{x: e.target.x, y: e.target.y}])
		else
			console.log(e.target.x, e.target.y)
	})
};

function indexOf(mas, val){
	var ret = -1;
	for (var i = 0; i < mas.length; i++)
		if(mas[i] == val)
			ret = i;
	return ret;
};

function searchObjectWithPar(arr, pars){
    var ret = -1
    for(var i = 0; i< arr.length; i++){
        for(var a = 0; a< pars.length; a++){
            if(typeof(arr[i][pars[a][0]]) == "number" && arr[i][pars[a][0]] == Number(pars[a][1])){
                if(a == pars.length-1)
                    ret = i
                else
                    continue
            }else{
                break;
            }
        }
    }

    return ret
}

function distXY(x1, y1, x2, y2){
	return Math.sqrt((x2 - x1) * (x2 - x1) +(y2 - y1) * (y2 - y1))
};

function round(v){
	return Math.round(v * 100)/100
};

function shuffle(o){ //v1.0
	for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
	return o;
};

function radToDeg(v){
	return v * 180/Math.PI;
}

// Построение массива индекса проверяемых элементов (начиная с элемента i, j квадратная область размером num)
	function buildMasIndex(i, j, num){
		var mas = new Array()
		for(var a=0; a<num; a++)
			for(var b=0; b<num; b++){
				var p = [i + a, j + b]
				mas.push(p)
			}
		return mas
	}

 
//Returns true if the circles are touching, or false if they are not
function circlesColliding(x1, y1, radius1, x2, y2, radius2){
	//compare the distance to combined radii
	var dx = x2 - x1;
	var dy = y2 - y1;
	var radii = radius1 + radius2;
	if ( ( dx * dx )  + ( dy * dy ) < radii * radii )
		return true;
	else
		return false;
}
// Проверка пересечения отрезка с кругом
// x,y,r - координаты круга
// x01,y01,x02,y02 - координаты отрезка
function cCross(x, y, r, x01, y01, x02, y02)
{
  //сдвигаем окружность и линию, так что окружность оказывается в начале координат
  x01-= x; x02-= x; y01-= y; y02-= y;

  var dx= x02 - x01;
  var dy= y02 - y01;

  //составляем коэфициенты квадратного уравнения на перечение прямой и окружности.
  //если на отрезке [0..1] есть отрицательные значения, значит отрезок пересекает окружность
  var a= dx*dx + dy*dy;
  var b= 2*(x01*dx + y01*dy);
  var c= x01*x01 + y01*y01-r*r;

  //а теперь проверяем, есть ли на отрезке [0..1] решения
  if (-b < 0)
	return (c < 0);
  if (-b < (2*a))
	return (4*a*c - b*b<0);

  return (a+b+c <0);
}
// Поиск пересечения двух отрезков //
function searcPointOfIntersection(x11,y11,x12,y12, x21,y21,x22,y22){
		var maxx1 = Math.max(x11, x12);
		var maxy1 = Math.max(y11, y12);
		var minx1 = Math.min(x11, x12); 
		var miny1 = Math.min(y11, y12);
		var maxx2 = Math.max(x21, x22); 
		var maxy2 = Math.max(y21, y22);
		var minx2 = Math.min(x21, x22);
		var miny2 = Math.min(y21, y22);

		if (minx1 > maxx2 || maxx1 < minx2 || miny1 > maxy2 || maxy1 < miny2)
			return false; // // Момент, када линии имеют одну общую вершину...
		  
		var dx1 = x12-x11// // Длина проекций первой линии на ось x и y
		var dy1 = y12-y11
		var dx2 = x22-x21// // Длина проекций второй линии на ось x и y
		var dy2 = y22-y21
		var dxx = x11-x21
		var dyy = y11-y21
		var div, mul

		div = (dy2*dx1-dx2*dy1)
		if ((div) == 0)
			return false// // Линии параллельны...
		 
		if (div > 0){ 
		  mul = (dx1*dyy-dy1*dxx)
		  if ((mul) < 0 || mul > div)
			  return false; // Первый отрезок пересекается за своими границами...
		 
		  mul = (dx2*dyy-dy2*dxx)
		  if ((mul) < 0 || mul > div)
			  return false; // // Второй отрезок пересекается за своими границами...
		   
		}else{
			mul = -(dx1*dyy-dy1*dxx)
			if ((mul) < 0 || mul > -div)
				return false; // // Первый отрезок пересекается за своими границами...
		   
			mul = -(dx2*dyy-dy2*dxx)
			if ((mul) < 0 || mul > -div)
				return false// // Второй отрезок пересекается за своими границами...
			
		}  
// --[[        var х1, у1, х2,у2 = x11,y11,x12,y12;
		// var х3, у3, х4,у4 = x21,y21,x22,y22;
		// ]]
		var xx=-((x11*y12-x12*y11)*(x22-x21)-(x21*y22-x22*y21)*(x12-x11))/((y11-y12)*(x22-x21)-(y21-y22)*(x12-x11));
		var yy=((y21-y22)*(-xx)-(x21*y22-x22*y21))/(x22-x21);
// --        print(xx,yy);
		var ret = {x: xx, y: yy};
		return ret;
	
	}
// Деление нацело
function div(val, by){
	return (val - val % by) / by;
}

var listeners_resize = new Array()
function listenResize(o){
	listeners_resize.push(o)
}

function ResizeGame(w, h) {
	var _w = typeof(w) == "number" ? w : window.innerWidth
	var _h = typeof(h) == "number" ? h : window.innerHeight
	window.scrollTo(0, 1);
	var newWidth = WIDTHGAME						// 
	var newHeight = HEIGHTGAME
/////////----- Canvas -----------/////////////
	var dWidth = __WIDTHBG - newWidth
	var dHeight = __HEIGHTBG - newHeight
////////--------------------//////////////////
	var widthArea = __WIDTHBG - dHeight									// Ширина игровой области
	var heightArea = __HEIGHTBG - dWidth									// Высота игровой области
	var releativeDisplay = _w / _h		// Отношение ширины экрана к высоте
	var releativeGame = __WIDTHBG / ((heightArea - dHeight))				// Отношение ширины игровой области к высоте
	// Есои отношение > 1, то ориегтация ландшафтная, иначе - портретная
	var gameArea = document.getElementById('gameArea');                 // Игровая область
	var img = document.getElementById('imgl2p');                        // Игровая область
	var bg = document.getElementById('background');                     // Игровая область
	var game = document.getElementById('gameField');                    // Игровая область
	if(window.orientation != undefined)
	if (releativeDisplay >= 1) {
		// To do (если ориентация ландшафтная)
		bg.style.display = "none";
		game.style.display = "none";
		img.style.display = "table-cell";
		// return
	}else{
		// To do (если ориентация портретная)
		bg.style.display = "block";
		game.style.display = "block";
		img.style.display = "none"
	}
	var height_game_area
	var width_game_area
	///////  Изменение размера области игры в соответствии с изменением размера окна ////////////////
	if (releativeDisplay >= releativeGame) {
		height_game_area = (__HEIGHTBG) * _h / (heightArea - dHeight)
		width_game_area = (__WIDTHBG) * _h / (heightArea - dHeight)
		gameArea.style.height = height_game_area + "px"
		gameArea.style.width = width_game_area + "px"
		gameArea.style.left = _w/2 - (__WIDTHBG * _h / (heightArea - dHeight) )/2 + "px"
		gameArea.style.top = -(dHeight/2) * _h / (heightArea - dHeight) + "px"
	} else
	{
		height_game_area = heightArea * _w / __WIDTHBG
		width_game_area = widthArea * _w / widthArea
		gameArea.style.height = height_game_area + "px"
		gameArea.style.width = width_game_area + "px"
		gameArea.style.top = _h/2 - (__HEIGHTBG * _w / __WIDTHBG)/2 + "px"
		gameArea.style.left = "0px"
	}
	for(var a=0; a<listeners_resize.length; a++)
		listeners_resize[a].resize(_w, _h, width_game_area, height_game_area, releativeGame)
}