function LogicGame()
{	
	var game_obs = new Array()
	var interface_obs = new Array()
	var tutorial_obs = new Array()
	var popup_obs = new Array()

	var _ctrlLogic = new ControlLogic(this)

	this.init = function(num, start){
		_ctrlLogic.init(num, start)
	}
//-- Interface for Controller
	this.rollDice = function(){
		_ctrlLogic.roll()
	}

	this.holdDice = function(v){
		var c_p = _ctrlLogic.currentPlayer()
		if(c_p == 0)
			_ctrlLogic.holdDice(v)
	}

	this.setScore = function(i, j){
		_ctrlLogic.setPoints(i, j)
	}

	var cur_hint = -1
	this.nextHint = function(){	
		cur_hint++
		if(cur_hint >=1)
			this.notifyObserver("endShowHints")
		else
			this.notifyObserver("setActiveHint", [cur_hint])
	}
	this.setPopUp = function(v){
		this.notifyObserver("setText", [v])
	}	

	this.pause = function(){

	}
//---------------------------//
///--- Observers ---///
	this.registerObserveToGame = function(v){
		if(indexOf(game_obs, v) == -1)
			game_obs.push(v)
	}
	this.registerObserveToInterface = function(v){
		if(indexOf(interface_obs, v) == -1)
			interface_obs.push(v)
	}
	this.registerObserveToTutorial = function(v){
		if(indexOf(tutorial_obs, v) == -1)
			tutorial_obs.push(v)
	}
	this.registerObserveToPopup = function(v){
		if(indexOf(popup_obs, v) == -1)
			popup_obs.push(v)
	}
////////////////////////////////
///-- Interface Notify observers --///
	this.notifyObserver = function(v, pars){
		for(var a=0; a<game_obs.length; a++){
			if(v == "init" && game_obs[a].init)
				game_obs[a].init.apply(game_obs[a], pars)
			if(v == "setHoldDice" && game_obs[a].setHoldDice)
				game_obs[a].setHoldDice.apply(game_obs[a], pars)
			if(v == "setNumRoll" && game_obs[a].setNumRoll)
				game_obs[a].setNumRoll.apply(game_obs[a], pars)
			if(v == "setPointOnDice" && game_obs[a].setPointOnDice)
				game_obs[a].setPointOnDice.apply(game_obs[a], pars)
			if(v == "setActivePlayer" && game_obs[a].setActivePlayer)
				game_obs[a].setActivePlayer.apply(game_obs[a], pars)
			if(v == "setPossibleScore" && game_obs[a].setPossibleScore)
				game_obs[a].setPossibleScore.apply(game_obs[a], pars)
			if(v == "setScore" && game_obs[a].setScore)
				game_obs[a].setScore.apply(game_obs[a], pars)
			if(v == "gameOver" && game_obs[a].gameOver)
				game_obs[a].gameOver.apply(game_obs[a], pars)
			if(v == "yatzy" && game_obs[a].yatzy)
				game_obs[a].yatzy.apply(game_obs[a], pars)
			if(v == "bonus" && game_obs[a].bonus)
				game_obs[a].bonus.apply(game_obs[a], pars)
			if(v == "flashRoll" && game_obs[a].flashRoll)
				game_obs[a].flashRoll.apply(game_obs[a], pars)
		}
		for(var a=0; a<interface_obs.length; a++){
			if(v == "setActivePlayer" && interface_obs[a].setActivePlayer)
				interface_obs[a].setActivePlayer.apply(interface_obs[a], pars)
		}
		for(var a=0; a<tutorial_obs.length; a++){
			if(v == "setActiveHint" && tutorial_obs[a].setActiveHint)
				tutorial_obs[a].setActiveHint.apply(tutorial_obs[a], pars)
			if(v == "endShowHints" && tutorial_obs[a].endShowHints)
				tutorial_obs[a].endShowHints.apply(tutorial_obs[a], pars)
			if(v == "showHints" && tutorial_obs[a].showHints)
				tutorial_obs[a].showHints.apply(tutorial_obs[a], pars)
		}
		for(var a=0; a<popup_obs.length; a++){
			if(v == "setText" && popup_obs[a].setText){
				popup_obs[a].setText.apply(popup_obs[a], pars)
			}
		}

	}
};