function ControlLogic(_observe)
{	
	var roller = new RollerLogic()				// Симулятор брасания костей
	var rules = new ControlRules()				// Управление игрой (в соответствии с правилами)
	var ai = new AI(this)

	var n_r = 3
			// Инициализация //
	var num_players = 0						
	var current_player = 0
	var num_rolls = 0
	var num_dices = 0
	var _bonus = null
	var num_text_no_more = 0
			//--------------//
	this.init = function(num, start){
		num_players = num
		current_player = start
		num_rolls = n_r
		num_dices = 5
		num_text_no_more = 3

		roller.init(num_dices)
		rules.init(num)

		_observe.notifyObserver("init", [num_players, num_dices])
		_observe.notifyObserver("setActivePlayer", [current_player])
		_observe.notifyObserver("setNumRoll", [num_rolls])
		if(current_player == 0)
			_observe.notifyObserver("flashRoll")

		updateScoreBoard()
		if(current_player == 1)
			ai.moveActive()
	}

	this.roll = function(robot){
		if(num_rolls<=0 || (current_player != 0 && !robot)){
			return
		}

		throwDices()
		showPossibleMoves()

		if(num_rolls<=0 && num_text_no_more>0 && current_player == 0){
			_observe.notifyObserver("setText", ["text_no_more_rolls"])
			num_text_no_more --
		}
		_observe.notifyObserver("setNumRoll", [num_rolls])
		MusicCTRL.play("sound1");

		
		return {dices: roller.getAllDices(), possible: rules.getPosPoints(current_player)}
	}

	this.holdDice = function(v){
		var dices = roller.getAllDices()
		if(dices[0] == 0)
			return
		var h = roller.setHold(v)
		_observe.notifyObserver("setHoldDice", [v, h])		
	}

	this.clearHolds = function(){
		roller.clearHolds()
		clearHolds()
	}

	this.setPoints = function(i, st_p){
		var st_p = rules.setPoints(current_player, i)
		if(i == 16 && typeof(st_p) == "number" && st_p>0){
			MusicCTRL.play("sound4")
			_observe.notifyObserver("yatzy")
			t_delayOn(2, function(){
				set(i, st_p)
			})
		}else{
			set(i, st_p)
		}

		return {points: rules.getPoints()}
		
	}

	this.currentPlayer = function(){
		return current_player
	}

	this.getPoints = function(){
		return {points: rules.getPoints()}
	}
//// PRIVATE ////
/// Установить очки ///
	function set(i, st_p){
		var winner = rules.checkGameOver()
		var points = rules.getPoints()
		var go_pars = {}
		if(typeof(points[0][7]) == "number" && points[0][7]>0 && !_bonus){
			MusicCTRL.play("sound4")
			_observe.notifyObserver("bonus", [current_player])
			_bonus = true			
		}
		
		updateScoreBoard()
		updatePosPointsBoard()



		if(typeof(winner.winner) == "number")
			go_pars.winner = winner.winner == 0 ? "user" : "bot"
		else
			go_pars.winner = null
		go_pars.user_score = points[0] ? points[0][points[0].length-1] : 0
		go_pars.opo_score = points[1] ? points[1][points[1].length-1] : 0
		go_pars.best_score = st_getBestUserPoint()
		go_pars.best = winner.best
		if(winner){
			console.log(winner.winner)
			if(winner.winner == 1)
				MusicCTRL.play("sound2");
			else if(winner.winner == 0)
				MusicCTRL.play("sound3");
			_observe.notifyObserver("gameOver", [go_pars])
			return
		}

		if(typeof(st_p) == "number"){
			_observe.notifyObserver("setNumRoll", [num_rolls])
			updateDices()
			switchPlayer()
		}
	}

/// Бросить кости ///
	function throwDices(){
		var mas_dices = roller.roll()
		for(var a=0; a<mas_dices.length; a++){
			_observe.notifyObserver("setPointOnDice", [mas_dices[a].ind, mas_dices[a].val])
		}

		num_rolls--
	}
/// Показать возможные варианты ///
	function showPossibleMoves(){
		var m_d = roller.getAllDices()
		var posScores = rules.setDices(current_player, m_d)
			for(var a=0; a<posScores.length; a++){
				_observe.notifyObserver("setPossibleScore", [posScores[a], a, current_player])
			}
	}
///
	function updateScoreBoard(){		
		var points = rules.getPoints()
		for(var a=0; a<points.length; a++)
			for(var b=0; b<points[a].length; b++)
				_observe.notifyObserver("setScore", [points[a][b], b, a])
	}

	function updatePosPointsBoard(){
		for(var a=0; a<num_players; a++){
			var p = rules.getPosPoints(a)
			for(var b=0; b<p.length; b++){
				_observe.notifyObserver("setPossibleScore", [p[b], b, a])
			}
		}		
	}

	function updateDices(){
		roller.clearDices()
		clearHolds()
	}

	function clearHolds(){
		var mas_dices = roller.getAllDices()
		for(var a=0; a<mas_dices.length; a++){
			_observe.notifyObserver("setHoldDice", [a, false])		
		}		
	}

	function switchPlayer(){
		if(current_player + 1 <= num_players - 1)
			current_player ++
		else
			current_player = 0

		num_rolls = n_r

		_observe.notifyObserver("setActivePlayer", [current_player])
		_observe.notifyObserver("setNumRoll", [num_rolls])
		if(current_player == 0)
			_observe.notifyObserver("flashRoll")


		if(current_player == 1)
			ai.moveActive()
	}
}