extend(VisualGame, createjs.Container);

function VisualGame(v)
{	
	this.initialize();
	var th = this
//--------------------------------//
	var coor = config_sizes.game.field		// Размеры объектов и координаты
	var _control = v 			//  Контроллер
	var mas_col = new Array()	//  массив колонок
	var mas_dices = new Array()	//  массив костей
	var btn_roll = null			// кнопка "Roll"

	

//-- InterFace for logic
	this.init = function(n_p, n_d){
		createColumns(n_p)
		createRightPart(n_d)
		for(var a=0; a<5; a++){
			var r = Math.round(Math.random()*5)+1
			mas_dices[a].setPoint(r, true)
		}
	}

	this.setHoldDice = function(num, v){
		mas_dices[num].setHold(v)
	}

	this.setNumRoll = function(v){
		// console.log("setNumRoll", v)
		btn_roll.setNumber(v)
	}

	this.flashRoll = function(){
		btn_roll.flash()
	}

	this.setPointOnDice = function(n, v){
		mas_dices[n].setPoint(v)
	}
//-------------------------------------------
	this.setActivePlayer = function(v){
		for(var a=0; a<mas_col.length; a++)
			mas_col[a].select()
		mas_col[v].select(true)
		mas_col[v].parent.addChild(mas_col[v])
	}

	this.setPossibleScore = function(v, i, j){
		if(typeof(v) == "number")
			mas_col[j].setPossiblePoint(v, i)
		else
			mas_col[j].clearPossiblePoints(i)
	}

	this.setScore = function(v, i, j){
		if(typeof(v) == "number")
			mas_col[j].setPointTo(v, i)
	}
//-----------------------------------//

	this.yatzy = function(){
		for(var a=0; a<mas_dices.length; a++){
			mas_dices[a].onAnim()
		}
		var ya = new MyVisualObject(1, "text_yatzy")
		setCoor(ya, 134, 282)
		this.addChild(ya)
		tw_tweenTo(ya, {x: ya.x, y: ya.y, alpha: .01, call:function(){
			ya.parent.removeChild(ya)
		}})
	}

	this.bonus = function(j){
		var ex = new MyVisualObject(2, "anim2")
		if(j == 0)
			setCoor(ex, 136, 217)
		else
			setCoor(ex, 195, 217)
		ex.play()
		ex.addEventListener("animationend", function(e){
			e.target.stop()
			if(e.target.parent)
				e.target.parent.removeChild(e.target)
		})

		this.addChild(ex)

	}

	this.gameOver = function(w){
		_control.gameOver(w)
	}

//// PRIVATE ////
	/// Колонки очков ///
	function createColumns(n){
		for(var a=0; a<n; a++){
			var coor = config_sizes.game.field
			var column = new PointsCol(a+1, _control)
			th.addChild(column)
			setCoor(column, coor["column_" + (a+1)][0], coor["column_" + (a+1)][1])
			mas_col[a] = column

			// dragAndDrop(column)
		}
	}

	function createRightPart(n){
		btn_roll = new ButtonRoll(_control)
		setCoor(btn_roll, coor.btn_roll[0], coor.btn_roll[1])
		th.addChild(btn_roll)

		for(var a=0; a<n; a++){
			var o = new Dice(a, _control)
			setCoor(o, coor["dice" + a][0], coor["dice" + a][1])
			th.addChild(o)
			mas_dices.push(o)
		}
	}
};