//basic javascript functions
var infoPage = 0;
var openView, infoView, sutraView, introTextView;
var chapter, sutra;
var startX, startY;
var openView, infoView, sutraView, infoTextView, cardView;


function displayInfo() {
  //get rid of previous texts
  while (infoTextView.hasChildNodes()) {
    infoTextView.removeChild(infoTextView.lastChild);
  }
  //create the paragraph tags
  var introT1 = document.createElement("p");
  var introT2 = document.createElement("p");
  //select the appropriate text and create the text nodes
  var text1 = document.createTextNode(infoText[infoPage + 1]);
  var text2 = document.createTextNode(infoText[infoPage + 2]);
  introT1.appendChild(text1);
  introT2.appendChild(text2);
  //if its the last page, add the copyright note
  if (infoPage == 4) {
    var nP = document.createElement("p");
    var nP2 = document.createElement("p");
    var cr = document.createElement("br");
    var cr1 = document.createTextNode("Text: \u00A9 2010 Amy Wheeler");
    var cr2 = document.createTextNode("App: \u00A9 2014 Michael Niemann");
    var a = document.createElement("a");
    a.setAttribute("href","http://www.amywheeler.com");
    a.setAttribute("target", "_blank");
    a.innerHTML = "Amy Wheeler website";
    introT2.appendChild(nP);
    introT2.appendChild(cr1);
    introT2.appendChild(cr);
    introT2.appendChild(cr2);
    introT2.appendChild(nP2);
    introT2.appendChild(a);
  }
  //append the text nodes to the divs
  infoTextView.appendChild(introT1);
  infoTextView.appendChild(introT2);
  //create the back button and add it to the div
  var bButton = document.createElement("button");
  var btext = document.createTextNode("back");
  bButton.appendChild(btext);
  infoTextView.appendChild(bButton);
  bButton.onclick = infoBack;
  bButton.setAttribute("class", "back");
  //create the next button if necessary and add it to the div
  if (infoPage != 4) {
    var nButton = document.createElement("button");
    var ntext = document.createTextNode("more");
    nButton.appendChild(ntext);
    infoTextView.appendChild(nButton);
    nButton.onclick = infoNext;
    nButton.setAttribute("class", "next");
  }
  openView.classList.add("hidden");
  infoView.classList.remove("hidden");
  infoTextView.classList.remove("hidden");
}
//clicking the back button
function infoBack() {
  if (infoPage == 0) {
    infoView.classList.add("hidden");
    infoTextView.classList.add("hidden");
    openView.classList.remove("hidden");
    return;
  }
  else if (infoPage == 2) {
    infoPage = 0;
  }
  else if (infoPage == 4) {
    infoPage = 2;
  }
  displayInfo();
}

//clicking the next button
function infoNext() {
  if (infoPage == 2) {
    infoPage = 4;
  }
  else if (infoPage == 0) {
    infoPage = 2;
  }
  displayInfo();
}
//select chapters 1 or 2
function openChap1() {
  chapter = 1;
  sutra = 1;
  showSutra();
}

function openChap2() {
  chapter = 2;
  sutra = 1;
  showSutra();
}
// function to display the sutra and its explanation
function showSutra() {
  var text, exp, tLength, eLength, wHeight, wWidth, tHeight,eHeight;
  var sText = document.getElementById("sutraText");
  var sExp = document.getElementById("sutraExp");
  //remove any existing text
  while (sText.hasChildNodes()) {
    sText.removeChild(sText.lastChild);
  }
  while (sExp.hasChildNodes()) {
    sExp.removeChild(sExp.lastChild);
  }

  //select appropriate text and explanation from array
  if (chapter == 1) {
    text = document.createTextNode(chap1Txt[sutra]);
    exp = document.createTextNode(chap1Exp[sutra]);
    tLength = chap1Txt[sutra].length * 0.74;
    eLength = chap1Exp[sutra].length * 0.6;
  }
  else if (chapter == 2) {
    text = document.createTextNode(chap2Txt[sutra]);
    exp = document.createTextNode(chap2Exp[sutra]);
    tLength = chap2Txt[sutra].length * 0.74;
    eLength = chap2Exp[sutra].length * 0.6;
  }
  //calculate the positioning of the text
  wHeight = window.innerHeight/17.6;
  wWidth = window.innerWidth/17.6;
  tLines = Math.floor(tLength/wWidth);
  if (tLines < 2) {tLines = 2};
  eLines = Math.floor((eLength/wWidth));
  tHeight = ((wHeight/2)-(tLines/2))*17.6;
  eHeight = ((wHeight/2)-(eLines/2))*17.6;

  //add the text and explanation to the div tags
  sText.appendChild(text);
  sExp.appendChild(exp);
  //set the margins
  sText.style.marginTop = Math.floor(tHeight) + "px";
  sExp.style.marginTop = Math.ceil(eHeight) + "px";
  //make sure the touch space is the entire window height
  sutraView.style.height = wHeight + "px";
//hide and show the respective views
  openView.classList.add("hidden");
//  cardView.showFront();
  sutraView.classList.remove("hidden");
  cardView.classList.remove("hidden");
  //initialize the touch and motion events;
  window.addEventListener("touchstart", handleStart);
  window.addEventListener("touchend", handleEnd);
  window.addEventListener("touchleave", handleEnd);
  window.addEventListener("devicemotion", handleMotionEvent);
}
// get the touch starting point
function handleStart(event) {
  var touches = event.changedTouches[0];
  startX = touches.pageX;
  startY = touches.pageY;
  event.preventDefault();
}
// get and process the touch ending point
function handleEnd (event) {
  var touches = event.changedTouches[0];
  var distX = touches.pageX - startX;
  var distY = touches.pageY - startY;
  event.preventDefault();
  if ((distX == 0) && (distY == 0)) {
    //just a tap, no move so flip the card
    cardView.toggle();
    return;
  }
  else if ((distX > 150) && (Math.abs(distY) < 50)) {
    //a swipe to the left, next higher sutra
    sutra -= 1;
    if ((sutra < 1) && (chapter == 1)) {sutra = 51;}
    else if ((sutra < 1) && (chapter == 2)) {sutra = 55;}
    if (cardView.flipped) {cardView.showFront();}
    showSutra();
  }
  //a swipe to the right, next lower sutra
  else if ((distX < -150) && (Math.abs(distY) < 50)) {
    sutra += 1;
    if ((sutra > 51) && (chapter == 1)) {sutra = 1;}
    else if ((sutra > 55) && (chapter == 2)) {sutra = 1;}
    if (cardView.flipped) {cardView.showFront();}
    showSutra();
  }
  //a swipe up, go back to chapter selection
  else if ((distY < -150) && (Math.abs(distX) < 50)) {
    window.removeEventListener("devicemotion", handleMotionEvent);
    window.removeEventListener("touchstart", handleStart);
    window.removeEventListener("touchend", handleEnd);
    window.removeEventListener("touchleave", handleEnd);
    sutraView.classList.add("hidden");
    cardView.classList.add("hidden");
    openView.classList.remove("hidden");
    return;
  }
}

function handleMotionEvent(event) {
    var x = event.accelerationIncludingGravity.x;
    var y = event.accelerationIncludingGravity.y;
    var z = event.accelerationIncludingGravity.z;
    if ((x > 12) || (y > 12) || (z > 12)) {
      if (chapter == 1) {
        sutra = Math.floor(Math.random() * (51 - 1 + 1)) + 1;
      }
      else if (chapter == 2) {
        sutra = Math.floor(Math.random() * (55 - 1 + 1)) + 1;
      }
      if (cardView.flipped) {cardView.showFront();}
    }
    showSutra();
}

window.onload = function() {
//get view elements
  openView = document.getElementById("openScreen");
  infoView = document.getElementById("infoDisp");
  sutraView = document.getElementById("sutraDisplay");
  infoTextView = document.getElementById("infoTxt");
  cardView = document.getElementById("fBox");
  document.getElementById("chap1").addEventListener("click", openChap1);
  document.getElementById("chap2").addEventListener("click", openChap2);
  document.getElementById("inf").addEventListener("click", displayInfo);
};
