(function() {

  $(function() {
    var $target, colors, cubaye, domov, face, facelist, faces, facet, facetlist, invisibles, mov, movlist, posstart, scramble, showCube, _i, _len;
    cubaye = new Cube;
    scramble = cubaye.getScramble().trim();
    movlist = scramble.split(' ');
    faces = {
      0: 'U',
      1: 'F',
      2: 'R',
      3: 'B',
      4: 'L',
      5: 'D'
    };
    colors = {
      'Y': 'yellow',
      'B': 'blue',
      'R': 'red',
      'G': 'green',
      'O': 'orange',
      'W': 'white'
    };
    invisibles = {
      'U': {
        'F': [3, 4, 5, 6, 7, 8],
        'R': [3, 4, 5, 6, 7, 8],
        'B': [3, 4, 5, 6, 7, 8],
        'L': [3, 4, 5, 6, 7, 8],
        'D': [0, 1, 2, 3, 4, 5, 6, 7, 8]
      },
      'F': {
        'U': [0, 1, 2, 3, 4, 5, 6],
        'R': [1, 2, 4, 5, 7, 8],
        'B': [0, 1, 2, 3, 4, 5, 6, 7, 8],
        'L': [0, 1, 3, 4, 6, 7],
        'D': [3, 4, 5, 6, 7, 8]
      },
      'R': {
        'U': [0, 1, 3, 4, 6, 7],
        'F': [0, 1, 3, 4, 6, 7],
        'B': [1, 2, 4, 5, 7, 8],
        'L': [0, 1, 2, 3, 4, 5, 6, 7, 8],
        'D': [0, 1, 3, 4, 6, 7]
      },
      'B': {
        'U': [3, 4, 5, 6, 7, 8],
        'F': [0, 1, 2, 3, 4, 5, 6, 7, 8],
        'R': [0, 1, 3, 4, 6, 7],
        'L': [1, 2, 4, 5, 7, 8],
        'D': [0, 1, 2, 3, 4, 5, 6]
      },
      'L': {
        'U': [1, 2, 4, 5, 7, 8],
        'F': [1, 2, 4, 5, 7, 8],
        'R': [0, 1, 2, 3, 4, 5, 6, 7, 8],
        'B': [0, 1, 3, 4, 6, 7],
        'D': [1, 2, 4, 5, 7, 8]
      },
      'D': {
        'U': [0, 1, 2, 3, 4, 5, 6, 7, 8],
        'F': [0, 1, 2, 3, 4, 5],
        'R': [0, 1, 2, 3, 4, 5],
        'B': [0, 1, 2, 3, 4, 5],
        'L': [0, 1, 2, 3, 4, 5]
      }
    };
    showCube = function() {
      var face, facet, i, j, _len, _ref, _results;
      _ref = cubaye.state;
      _results = [];
      for (i = 0, _len = _ref.length; i < _len; i++) {
        face = _ref[i];
        _results.push((function() {
          var _len2, _results2;
          _results2 = [];
          for (j = 0, _len2 = face.length; j < _len2; j++) {
            facet = face[j];
            _results2.push($(".facet-" + faces[i] + j).css('background-color', colors[facet]));
          }
          return _results2;
        })());
      }
      return _results;
    };
    domov = function() {
      var movclass;
      window.ismoving = true;
      $('.showcube').addClass("transitioned");
      cubaye.combination(movlist[0]);
      movclass = "show-" + movlist[0][0];
      if (movlist[0].length > 1) {
        if (movlist[0][1] === "'") {
          movclass += " " + movclass + "-inv";
        } else if (movlist[0][1] === "2") {
          movclass += " " + movclass + "-double";
        }
      }
      return $('.cube').addClass(movclass);
    };
    showCube();
    $(".showcube").clone().removeClass('showcube').addClass("shadowcube").prependTo('.container');
    for (mov in invisibles) {
      facelist = invisibles[mov];
      for (face in facelist) {
        facetlist = facelist[face];
        for (_i = 0, _len = facetlist.length; _i < _len; _i++) {
          facet = facetlist[_i];
          $(".showcube .facet-" + face + facet).addClass("turn-" + mov + "-hidden");
          $(".shadowcube .facet-" + face + facet).addClass("turn-" + mov + "-visible");
        }
      }
    }
    window.ismoving = false;
    window.setInterval(function() {
      if (movlist.length && window.ismoving === false) return domov();
    }, 100);
    $(".showcube").bind('transitionend oTransitionEnd webkitTransitionEnd', function() {
      showCube();
      $(this).removeClass("transitioned");
      $(this).removeClass("show-" + movlist[0]);
      $('.cube').removeClass("show-" + movlist[0][0] + " show-" + movlist[0][0] + "-inv show-" + movlist[0][0] + "-double");
      window.ismoving = false;
      movlist.shift();
      return true;
    });
    $(document).bind('keydown', function(e) {
      if (e.which === 37) movlist.push("y");
      if (e.which === 39) movlist.push("y'");
      if (e.which === 38) movlist.push("x");
      if (e.which === 40) movlist.push("x'");
      if (e.which === 85) movlist.push("R");
      if (e.which === 73) movlist.push("U");
      if (e.which === 82) movlist.push("L'");
      if (e.which === 69) movlist.push("U'");
      if (e.which === 74) movlist.push("R'");
      if (e.which === 70) movlist.push("L");
      if (e.which === 72) movlist.push("F");
      if (e.which === 71) movlist.push("F'");
      if (e.which === 75) movlist.push("D'");
      if (e.which === 68) movlist.push("D");
      if (e.which === 76) movlist.push("B'");
      if (e.which === 83) movlist.push("B");
      return true;
    });
    posstart = [0, 0];
    $target = null;
    $(document).bind("mousedown", function(ev) {
      posstart = [ev.clientX, ev.clientY];
      $target = $(ev.target);
      ev.preventDefault();
      return false;
    });
    $(document).bind("mouseup", function(ev) {
      var offsetX, offsetY, posend;
      posend = [ev.clientX, ev.clientY];
      offsetX = posend[0] - posstart[0];
      offsetY = posend[1] - posstart[1];
      if ($target.is('.facet-F0, .facet-F1, .facet-F2') && (Math.abs(offsetX) > Math.abs(offsetY))) {
        if (offsetX > 0) {
          movlist.push("U'");
        } else if (offsetX < 0) {
          movlist.push("U");
        }
      } else if ($target.is('.facet-F6, .facet-F7, .facet-F8') && (Math.abs(offsetX) > Math.abs(offsetY))) {
        if (offsetX > 0) {
          movlist.push("D");
        } else if (offsetX < 0) {
          movlist.push("D'");
        }
      } else if ($target.is('.facet-F2, .facet-F5, .facet-F8') && (Math.abs(offsetY) > Math.abs(offsetX))) {
        if (offsetY > 0) {
          movlist.push("R'");
        } else if (offsetY < 0) {
          movlist.push("R");
        }
      } else if ($target.is('.facet-F0, .facet-F3, .facet-F6') && (Math.abs(offsetY) > Math.abs(offsetX))) {
        if (offsetY > 0) {
          movlist.push("L");
        } else if (offsetY < 0) {
          movlist.push("L'");
        }
      } else if ($target.is('.facet-R0, .facet-R1, .facet-R2, .facet-R3, .facet-R4, .facet-R5, .facet-R6, .facet-R7, .facet-R8') && (Math.abs(offsetY) > Math.abs(offsetX))) {
        if (offsetY > 0) {
          movlist.push("F");
        } else if (offsetY < 0) {
          movlist.push("F'");
        }
      } else {
        if (Math.abs(offsetX) > Math.abs(offsetY)) {
          if (offsetX > 0) {
            movlist.push("y'");
          } else if (offsetX < 0) {
            movlist.push("y");
          }
        } else if (Math.abs(offsetY) > Math.abs(offsetX)) {
          if (offsetY > 0) {
            movlist.push("x'");
          } else if (offsetY < 0) {
            movlist.push("x");
          }
        }
      }
      $target = null;
      ev.preventDefault();
      return false;
    });
    return $(document).bind("mouseup", function(ev) {
      ev.preventDefault();
      return false;
    });
  });

}).call(this);
