(function() {

  describe("Cube", function() {
    beforeEach(function() {
      return this.cube = new Cube;
    });
    it("turns with R movement", function() {
      var expected_state;
      this.cube.turn('R');
      expected_state = [['Y', 'Y', 'B', 'Y', 'Y', 'B', 'Y', 'Y', 'B'], ['B', 'B', 'W', 'B', 'B', 'W', 'B', 'B', 'W'], ['R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['Y', 'G', 'G', 'Y', 'G', 'G', 'Y', 'G', 'G'], ['O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'G', 'W', 'W', 'G', 'W', 'W', 'G']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with U movement", function() {
      var expected_state;
      this.cube.turn('U');
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['R', 'R', 'R', 'B', 'B', 'B', 'B', 'B', 'B'], ['G', 'G', 'G', 'R', 'R', 'R', 'R', 'R', 'R'], ['O', 'O', 'O', 'G', 'G', 'G', 'G', 'G', 'G'], ['B', 'B', 'B', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("does simple edge permutation", function() {
      var expected_state;
      this.cube.combination("RRURURRRUUURRRUUURRRURRR");
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'R', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['R', 'O', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['O', 'B', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with F movement", function() {
      var expected_state;
      this.cube.turn('F');
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'O', 'O', 'O'], ['B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['Y', 'R', 'R', 'Y', 'R', 'R', 'Y', 'R', 'R'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['O', 'O', 'W', 'O', 'O', 'W', 'O', 'O', 'W'], ['R', 'R', 'R', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with L movement", function() {
      var expected_state;
      this.cube.turn('L');
      expected_state = [['G', 'Y', 'Y', 'G', 'Y', 'Y', 'G', 'Y', 'Y'], ['Y', 'B', 'B', 'Y', 'B', 'B', 'Y', 'B', 'B'], ['R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['G', 'G', 'W', 'G', 'G', 'W', 'G', 'G', 'W'], ['O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['B', 'W', 'W', 'B', 'W', 'W', 'B', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with B movement", function() {
      var expected_state;
      this.cube.turn('B');
      expected_state = [['R', 'R', 'R', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['R', 'R', 'W', 'R', 'R', 'W', 'R', 'R', 'W'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['Y', 'O', 'O', 'Y', 'O', 'O', 'Y', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'O', 'O', 'O']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with D movement", function() {
      var expected_state;
      this.cube.turn('D');
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'B', 'B', 'B', 'B', 'B', 'O', 'O', 'O'], ['R', 'R', 'R', 'R', 'R', 'R', 'B', 'B', 'B'], ['G', 'G', 'G', 'G', 'G', 'G', 'R', 'R', 'R'], ['O', 'O', 'O', 'O', 'O', 'O', 'G', 'G', 'G'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("does combination of all simple movements correctly", function() {
      var expected_state;
      this.cube.combination("RUFLDB");
      expected_state = [['G', 'R', 'R', 'G', 'Y', 'Y', 'O', 'O', 'W'], ['Y', 'B', 'R', 'Y', 'B', 'R', 'G', 'W', 'W'], ['B', 'G', 'Y', 'B', 'R', 'G', 'O', 'W', 'G'], ['B', 'Y', 'O', 'R', 'G', 'O', 'R', 'W', 'W'], ['Y', 'O', 'B', 'Y', 'O', 'B', 'G', 'G', 'R'], ['W', 'B', 'B', 'W', 'W', 'R', 'O', 'O', 'Y']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with M movement", function() {
      var expected_state;
      this.cube.turn('M');
      expected_state = [['Y', 'B', 'Y', 'Y', 'B', 'Y', 'Y', 'B', 'Y'], ['B', 'W', 'B', 'B', 'W', 'B', 'B', 'W', 'B'], ['R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['G', 'Y', 'G', 'G', 'Y', 'G', 'G', 'Y', 'G'], ['O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'G', 'W', 'W', 'G', 'W', 'W', 'G', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with E movement", function() {
      var expected_state;
      this.cube.turn('E');
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'B', 'B', 'R', 'R', 'R', 'B', 'B', 'B'], ['R', 'R', 'R', 'G', 'G', 'G', 'R', 'R', 'R'], ['G', 'G', 'G', 'O', 'O', 'O', 'G', 'G', 'G'], ['O', 'O', 'O', 'B', 'B', 'B', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("turns with S movement", function() {
      var expected_state;
      this.cube.turn('S');
      expected_state = [['Y', 'Y', 'Y', 'O', 'O', 'O', 'Y', 'Y', 'Y'], ['B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['R', 'Y', 'R', 'R', 'Y', 'R', 'R', 'Y', 'R'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['O', 'W', 'O', 'O', 'W', 'O', 'O', 'W', 'O'], ['W', 'W', 'W', 'R', 'R', 'R', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("converts inversion and double movements", function() {
      var test;
      test = this.cube.convert("RUR'U2");
      return expect(test).toEqual("RURRRUU");
    });
    it("converts composed formula", function() {
      var expected, result;
      result = this.cube.convert("R2dM'U2Md'L2u2D2");
      expected = "RRDUUUMMMUUMDUUUDUUUDUUULLUEUEDD";
      return expect(result).toEqual(expected);
    });
    it("does complex edge permutation", function() {
      var expected_state;
      this.cube.combination("M2U'M'U2MU'M2");
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'R', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['R', 'O', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['O', 'B', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    it("does complex corner permutation", function() {
      var expected_state;
      this.cube.combination("l'UR'D2RU'R'z'R2U2x'y'");
      expected_state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'B', 'R', 'B', 'B', 'B', 'B', 'B', 'B'], ['G', 'R', 'G', 'R', 'R', 'R', 'R', 'R', 'R'], ['O', 'G', 'B', 'G', 'G', 'G', 'G', 'G', 'G'], ['R', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      return expect(this.cube.state).toEqual(expected_state);
    });
    return it("displays a cube in text mode", function() {
      var expected;
      expected = "\n    YYY\n    YYY\n    YYY\n\nOOO BBB RRR GGG\nOOO BBB RRR GGG\nOOO BBB RRR GGG\n\n    WWW\n    WWW\n    WWW\n";
      return expect(this.cube.toString()).toEqual(expected);
    });
  });

}).call(this);
