(function() {
  var Cube;

  window.Cube = Cube = (function() {

    function Cube() {
      this.state = [['Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'], ['B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B'], ['R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R'], ['G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G'], ['O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'], ['W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W']];
      this.movs = {
        'R': [[[0, 2], [3, 6], [5, 2], [1, 2]], [[0, 5], [3, 3], [5, 5], [1, 5]], [[0, 8], [3, 0], [5, 8], [1, 8]], [[2, 0], [2, 2], [2, 8], [2, 6]], [[2, 1], [2, 5], [2, 7], [2, 3]]],
        'U': [[[0, 0], [0, 2], [0, 8], [0, 6]], [[0, 1], [0, 5], [0, 7], [0, 3]], [[1, 0], [4, 0], [3, 0], [2, 0]], [[1, 1], [4, 1], [3, 1], [2, 1]], [[1, 2], [4, 2], [3, 2], [2, 2]]],
        'F': [[[0, 6], [2, 0], [5, 2], [4, 8]], [[0, 7], [2, 3], [5, 1], [4, 5]], [[0, 8], [2, 6], [5, 0], [4, 2]], [[1, 0], [1, 2], [1, 8], [1, 6]], [[1, 1], [1, 5], [1, 7], [1, 3]]],
        'L': [[[0, 0], [1, 0], [5, 0], [3, 8]], [[0, 3], [1, 3], [5, 3], [3, 5]], [[0, 6], [1, 6], [5, 6], [3, 2]], [[4, 0], [4, 2], [4, 8], [4, 6]], [[4, 1], [4, 5], [4, 7], [4, 3]]],
        'B': [[[0, 0], [4, 6], [5, 8], [2, 2]], [[0, 1], [4, 3], [5, 7], [2, 5]], [[0, 2], [4, 0], [5, 6], [2, 8]], [[3, 0], [3, 2], [3, 8], [3, 6]], [[3, 1], [3, 5], [3, 7], [3, 3]]],
        'D': [[[1, 6], [2, 6], [3, 6], [4, 6]], [[1, 7], [2, 7], [3, 7], [4, 7]], [[1, 8], [2, 8], [3, 8], [4, 8]], [[5, 0], [5, 2], [5, 8], [5, 6]], [[5, 1], [5, 5], [5, 7], [5, 3]]],
        'M': [[[0, 1], [3, 7], [5, 1], [1, 1]], [[0, 4], [3, 4], [5, 4], [1, 4]], [[0, 7], [3, 1], [5, 7], [1, 7]]],
        'E': [[[1, 3], [4, 3], [3, 3], [2, 3]], [[1, 4], [4, 4], [3, 4], [2, 4]], [[1, 5], [4, 5], [3, 5], [2, 5]]],
        'S': [[[0, 3], [2, 1], [5, 5], [4, 7]], [[0, 4], [2, 4], [5, 4], [4, 4]], [[0, 5], [2, 7], [5, 3], [4, 1]]]
      };
    }

    Cube.prototype.turn = function(letter) {
      var couple0, couple1, couple2, couple3, permutation, _i, _len, _ref, _ref2, _results;
      _ref = this.movs[letter];
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        permutation = _ref[_i];
        couple0 = permutation[0];
        couple1 = permutation[1];
        couple2 = permutation[2];
        couple3 = permutation[3];
        _results.push((_ref2 = [this.state[couple3[0]][couple3[1]], this.state[couple0[0]][couple0[1]], this.state[couple1[0]][couple1[1]], this.state[couple2[0]][couple2[1]]], this.state[couple0[0]][couple0[1]] = _ref2[0], this.state[couple1[0]][couple1[1]] = _ref2[1], this.state[couple2[0]][couple2[1]] = _ref2[2], this.state[couple3[0]][couple3[1]] = _ref2[3], _ref2));
      }
      return _results;
    };

    Cube.prototype.convert = function(movlist) {
      var key, result, value;
      result = (function() {
        var _len, _results;
        _results = [];
        for (key = 0, _len = movlist.length; key < _len; key++) {
          value = movlist[key];
          if (value === "'") {
            _results.push(movlist[key - 1] + movlist[key - 1]);
          } else if (value === "2") {
            _results.push(movlist[key - 1]);
          } else {
            _results.push(value);
          }
        }
        return _results;
      })();
      result = result.join('');
      result = (function() {
        var _len, _results;
        _results = [];
        for (key = 0, _len = result.length; key < _len; key++) {
          value = result[key];
          if (value === "r") {
            _results.push("RM");
          } else if (value === "u") {
            _results.push("UE");
          } else if (value === "f") {
            _results.push("FS");
          } else if (value === "l") {
            _results.push("LMMM");
          } else if (value === "d") {
            _results.push("DUUU");
          } else if (value === "b") {
            _results.push("BEEE");
          } else if (value === "x") {
            _results.push("RMLLL");
          } else if (value === "y") {
            _results.push("UEDDD");
          } else if (value === "z") {
            _results.push("FSBBB");
          } else {
            _results.push(value);
          }
        }
        return _results;
      })();
      return result = result.join('');
    };

    Cube.prototype.combination = function(movlist) {
      var mov, _i, _len, _results;
      movlist = this.convert(movlist);
      _results = [];
      for (_i = 0, _len = movlist.length; _i < _len; _i++) {
        mov = movlist[_i];
        _results.push(this.turn(mov));
      }
      return _results;
    };

    Cube.prototype.getScramble = function() {
      var bad, dirs, faces, i, j, out, random, test, turn;
      faces = ['U', 'D', 'L', 'R', 'F', 'B'];
      dirs = ["", "'", "2"];
      out = "";
      bad = [0, 0, 0, 0, 0, 0];
      random = function(n) {
        return Math.floor(Math.random() * (n + 1));
      };
      for (i = 1; i <= 25; i++) {
        turn = test = true;
        while (test) {
          turn = random(5);
          test = bad[turn] === 1;
        }
        out += "" + faces[turn] + dirs[random(2)] + " ";
        bad[turn] = 1;
        for (j = 0; j <= 5; j++) {
          if (j !== turn && i ^ 1 !== turn) bad[j] = 0;
        }
      }
      return out;
    };

    Cube.prototype.scramble = function() {
      var scramble;
      scramble = this.getScramble();
      this.combination(scramble.split(' ').join(''));
      return scramble;
    };

    Cube.prototype.toString = function() {
      return "\n    " + (this.state[0].slice(0, 3).join('')) + "\n    " + (this.state[0].slice(3, 6).join('')) + "\n    " + (this.state[0].slice(6, 9).join('')) + "\n\n" + (this.state[4].slice(0, 3).join('')) + " " + (this.state[1].slice(0, 3).join('')) + " " + (this.state[2].slice(0, 3).join('')) + " " + (this.state[3].slice(0, 3).join('')) + "\n" + (this.state[4].slice(3, 6).join('')) + " " + (this.state[1].slice(3, 6).join('')) + " " + (this.state[2].slice(3, 6).join('')) + " " + (this.state[3].slice(3, 6).join('')) + "\n" + (this.state[4].slice(6, 9).join('')) + " " + (this.state[1].slice(6, 9).join('')) + " " + (this.state[2].slice(6, 9).join('')) + " " + (this.state[3].slice(6, 9).join('')) + "\n\n    " + (this.state[5].slice(0, 3).join('')) + "\n    " + (this.state[5].slice(3, 6).join('')) + "\n    " + (this.state[5].slice(6, 9).join('')) + "\n";
    };

    return Cube;

  })();

}).call(this);
