(function(){
    'use strict';

    var DOM = {
        init: function(){
            if( typeof window.addEventListener === 'function' ){
                this.addListener = function( el, type, fn ){
                    el.addEventListener( type, fn, false );
                };
                this.removeListener = function( el, type, fn ){
                    el.removeEventListener( type, fn, false );
                };
            }else if( typeof document.attachEvent === 'function' ){ // IE
                this.addListener = function( el, type, fn ){
                    el.attachEvent( 'on' + type, fn );
                };
                this.removeListener = function( el, type, fn ){
                    el.detachEvent( 'on' + type, fn );
                };
            }else{ // older browsers
                this.addListener = function( el, type, fn ){
                    el['on' + type] = fn;
                };
                this.removeListener = function( el, type ){
                    el['on' + type] = null;
                };
            }
        }
    };
    DOM.init();

    if( !navigator.getDeviceStorage ){ // browser test shim
        navigator.getDeviceStorage = function(){
            return {
                get: function(  ){
                    var out = {};
                    setTimeout( function(  ){
                        var t = book.toString().substr(26);t = t.substr(0,t.length-10);
                        out.result = t;
                        out.onsuccess && out.onsuccess();
                    },10);
                    return out;
                },
                enumerate: function(  ){
                    var out = {
                        'continue': function(  ){
                            this.result = null;
                            this.onsuccess();
                        }
                    };
                    setTimeout( function(  ){
                        out.result = {name:'*test.fb2', path: '*test.fb2'};
                        out.onsuccess && out.onsuccess();
                    },10);
                    return out;
                }
            };
        };
    }
    var getFileTree = function( store, callback ){
        var nodes = {},
            files = navigator.getDeviceStorage( store ),
            cursor = files.enumerate();
        cursor.onsuccess = function(){
            var file = this.result;
            if( file != null ){
                var tokens = file.name.split( '/' ), i, _i,
                    token, root = nodes, el;
                tokens[0] === '' && tokens.shift();
                for( i = 0, _i = tokens.length; i < _i; i++ ){
                    token = tokens[i];
                    if( i === _i - 1 ){
                        el = {name: token, path: file.path, '?file': true};
                        root[token] = el;
                    }else{
                        if( root[token] ){
                            root = root[token];
                        }else{
                            root = ( root[token] = {"..": root} );
                        }
                    }
                }
                this.continue();
            }else{
                callback && callback( void 0, nodes );
            }
        };
        cursor.onerror = function(){
            callback && callback( this.error );
        };
        return nodes;
    };
    var itemTPL = function( obj ){
        return '<div class="item' + (obj.cls ? ' ' + obj.cls : '') + '">' + obj.name +
            (obj.order === 1 ? '<span class="list_item_arrow"></span>' : '') +
            '</div>'
    };

    var drawTree = function( el, tree ){
        var list = [], d = document;
        for( var i in tree ) if( tree.hasOwnProperty( i ) ){
            list.push( {name: i, el: tree[i], order: i == '..' ? 0 : (tree[i]['?file'] ? 2 : 1)} );
        }

        if( list.length ){
            el.innerHTML = '';
            list.sort(function( a, b ){
                return a.order === b.order ? ( a.name < b.name ? 1 : ( a.name > b.name ? -1 : 0 ) ) : a.order - b.order;
            } ).forEach( function( item ){
                    var div = d.createElement( 'div' ), child;
                    div.innerHTML = itemTPL( item );
                    child = div.childNodes[0];
                    DOM.addListener( child, 'click', function(){
                        item.order < 2 && drawTree( el, item.el );
                        if( item.order === 2 ){

                            zFB.openFile(item.name);
                            document.querySelector('#openDialog' ).style.display = 'none';
                            document.querySelector('#openFile' ).style.display = 'block';
                        }
                    } );
                    el.appendChild( child );
                } );
        }else{
            el.innerHTML = itemTPL( {name: 'No items found'} );
        }
    };
    var drawArray = window.drawArray = function( el, arr, fn ){
        var d = document;
        el.innerHTML = '';
        arr.forEach( function( item, i ){
            var div = d.createElement( 'div' ), child;
            div.innerHTML = itemTPL( {name:item.title} );
            child = div.childNodes[0];
            DOM.addListener( child, 'click', function(){
                fn(item, i);
            } );
            el.appendChild( child );
        } );
    };
    window.drawTree = drawTree;
    window.getFileTree = getFileTree;
    window.zFB = {
        openDialog: function(){
            getFileTree( 'sdcard', function( err, tree ){
                if( err )
                    document.querySelector( '#openDialog .list' ).innerHTML = itemTPL( {name: err.name, cls: 'error'} );
                else
                    drawTree( document.querySelector( '#openDialog .list' ), tree );

            } );
        },
        openFile: function( name ){
            var sdcard = navigator.getDeviceStorage( 'sdcard' );
            var request = sdcard.get( name );
            request.onsuccess = function(){
                var file = this.result,
                    reader = new FileReader();

                reader.onload = function(e) {
                    //[].slice.call(document.querySelectorAll('binary')).forEach(function(el){el.parentNode.removeChild(el)})
                    var t = this.result;
                    var dom = Z.util.H.prototype.buildDOM(Z.util.H.prototype.tokenize(t));
                    var sections = [];
                    var flat = function( node ){
                        var nodes = node.childNodes,
                            tag = (node.tagName||'').toLowerCase(), text = '';
                        nodes.forEach( function( el ){

                            text += typeof(el) === 'string'? el : ' '+flat(el)+' ';
                        });
                        return text.trim();
                    };
                    var proceed = function(node){

                        var nodes = node.childNodes,
                            tag = (node.tagName||'').toLowerCase();
                        if( tag !== 'binary' ){
                            if( tag === 'section' ){
                                sections.push(node);
                                nodes && nodes.forEach( function( el ){
                                    if( typeof el !== 'string' ){
                                        (el.tagName||'').toLowerCase() === 'title' && (node.title = flat(el));

                                    }
                                });
                            }else{
                                nodes && nodes.forEach( function( el ){
                                    if( typeof el !== 'string' ){
                                        proceed(el);
                                    }
                                });
                            }
                        }

                    };
                    var postProcessing = [];
                    var hyp = function(  ){
                        if(postProcessing.length){
                            for( var i = 0; i < 3; i++ ){
                                var el = postProcessing.shift();
                                if( !el ) break;
                                Z.util.Hyphen.process('ru',el[1], function( data ){
                                    this.nodeValue = data;
                                }.bind(el[0]));
                            }
                        }
                        if(postProcessing.length){
                            setTimeout(hyp, 10);
                        }
                    };
                    var build = function(obj){
                        var container, i, attrs, setter;
                        if( typeof obj !== 'object' ){
                            container = document.createTextNode(obj);
                            obj.trim().length > 0 && postProcessing.push([container, obj]);
                        }else{
                            if(obj.root)
                                container = document.createDocumentFragment();
                            else{
                                if(obj.tagName==='P' ){
                                    container = document.createElement('P');
                                }else{
                                    container = document.createElement('div');
                                    container.className = obj.tagName.toLowerCase();
                                }
                                if( attrs = obj.attr )
                                    for( i in attrs)
                                        if( attrs.hasOwnProperty( i ) ){
                                            if( setter = mapping[ i ] )
                                                setter(container, attrs[i]);
                                            else
                                                container.setAttribute(i, attrs[i])
                                        }

                            }
                            obj.childNodes && obj.childNodes.map(build).forEach(container.appendChild.bind(container));
                        }

                        return container;
                    };
                    proceed(dom);
                    var current;
                    DOM.addListener( document.querySelector( '#openFile .next' ), 'click', function(  ){
                        current++;
                        openSection(sections[current], current);
                    });
                    DOM.addListener( document.querySelector( '#openFile .back' ), 'click', function(  ){
                        current--;
                        openSection(sections[current], current);
                    });
                    var openSection = function( item, i ){

                        current = i;
                        var back = {
                                el: document.querySelector( '#openFile .back' ),
                                desc: document.querySelector( '#openFile .back .btn_desc' )
                            },
                            next = {
                                el: document.querySelector( '#openFile .next' ),
                                desc: document.querySelector( '#openFile .next .btn_desc' )
                            };
                        back.style = back.el.style;
                        next.style = next.el.style;
                        if( i === 0 ){
                            back.style.display = 'none';
                        }else{
                            back.style.display = 'block';
                            back.desc.innerHTML = '&nbsp;'+ sections[i - 1].title;
                        }
                        if( i === sections.length - 1 ){
                            next.style.display = 'none';
                        }else{
                            next.style.display = 'block';
                            next.desc.innerHTML = '&nbsp;'+ sections[i - 1].title;
                        }

                        var text = document.querySelector( '#openFile .text' );
                        text.innerHTML = '';
                        item.root = true;
                        postProcessing = [];
                        var dom = build(item);
                        hyp();
                        text.appendChild(dom);
                        document.querySelector('#openFile').scrollTop = 0;
                    };
                    drawArray( document.querySelector( '#openFile .list' ), sections, function( item, i ){

                        document.querySelector( '#openFile .list' ).style.display = 'none';

                        document.querySelector( '#openFile .book' ).style.display = 'block';
                        openSection(item, i);


                    } );

                    /*var text = this.result,
                        tags = [];
                    text.replace(/<\/?binary/gi,function(tag, pos){
                        var close = !!~tag.indexOf('/');
                        tags.push(pos);
                        return tag;

                    });
                    text = text.substr(0,tags[0])+ text.substr(tags[tags.length - 1]+9);

                    Z.util.Hyphen.process('ru',text, function( text ){

                        document.querySelector('#openFile' ).innerHTML = text;
                    });*/

                };
                if(typeof file === 'string')
                    reader.onload.call({result:file});
                else
                    reader.readAsText(file,'utf-8');
            };

            request.onerror = function(){
                console.warn( "Unable to get the file: " + this.error );
            };
        },
        drawTree: drawTree
    };
    //zFB.openDialog();
    //zFB.openFile( 'Barochnyiy_tsikl_1_Rtut.1055.fb2Barochnyiy_tsikl_1_Rtut.1055.fb2Barochnyiy_tsikl_1_Rtut.1055.fb2' );
    zFB.openDialog();


})();