var _;
//This could be a lot safer,
//only one next call should be allowed and a timeout could be used.
var synchronousEach = function(array, eachCallback, completeCallback) {
    var i = -1;
    var complete = completeCallback || function(){};

    var next = function() {
        i++;
        if (i < array.length) {
            eachCallback(array[i], _.once(next), i);
        }
        else {
          complete();
        }
    };

    if(array.length === 0) {
      complete();
    } else {
      next();
    }
};
var toast = function(content, customClass){
  var width = 260;
  var $toastEl = $('<div class="ui-loader ui-overlay-shadow ui-corner-all toast"></div>');
  var theme = 'a';
  var html = content;
  var css = {
    left: ($(window).width() - width)/2,
    top: $(window).height()/2 - 100,
    width: width + "px",
    'text-align': 'center'
  };
  var click;
  var delay = 2000;
  if(_.isObject(content)){
    html = content.html || html;
    theme = content.theme || theme;
    css = _.extend(css, content.css || {});
    click = content.click;
  }
  $toastEl.addClass("ui-body-" + theme).css(css).html(html);
  $.mobile.pageContainer.append($toastEl);
  if(click){
    $toastEl.click(click);
  }
  $toastEl
    .fadeIn()
    .delay( delay )
    .fadeOut( 500, function(){
      $toastEl.remove();
    });
};
_.mixin({
  takeF : function(arr, iterator) {
    var lastIdx = 0;
    while(lastIdx < arr.length) {
      if(!iterator(arr[lastIdx])) {
        break;
      }
      lastIdx++;
    }
    return arr.slice(0, lastIdx + 1);
  },
  delayed : function(func, timeP) {
    var time = timeP || 0;
    return function() {
      var context = this, args = arguments;
      window.setTimeout(function(){
        func.apply(context, args);
      }, time);
    };
  }
});