window.onload = function() {

    var adOptions = {
        APP_ID: "TomitaMilitaru_ZipCodeRomania_other",
        TYPE: "Banner",
        IS_INTERSTITIAL_AD: false,
        REFRESH_RATE: 30
    };

    //create the Ad object based on the above options
    var ad = Inneractive.createAd(adOptions);
    ad
        .placement("bottom", "center")
        .addTo(document.getElementById("ad-frame"));

  var apiURL = 'http://openapi.ro/api/addresses.json?description=';
  var defaultSearchTerm = 'strada Marin Preda';
  var errorMsg = document.getElementById('error');
  var searchInput = document.getElementById('term');
  var searchButton = document.getElementById('search');
  var definitionText = document.getElementById('definitionText');
  var request = null;
  var translate = document.webL10n.get;

  var form = document.querySelector('form');
  form.addEventListener('submit', function(e) {
      e.preventDefault();
      search();
  }, false);

  search();

  // ---

  function search() {

    // Are we searching already? Then stop that search
    if(request && request.abort) {
      request.abort();
    }


    definitionText.innerHTML = '<p>' + translate('searching') + '</p>';
    errorMsg.classList.add('hidden');


    var term = searchInput.value;
    if(term.length === 0) {
      term = defaultSearchTerm;
    }

    var url = apiURL + term;

    // If you don't set the mozSystem option, you'll get CORS errors (Cross Origin Resource Sharing)
    // You can read more about CORS here: https://developer.mozilla.org/docs/HTTP/Access_control_CORS
    request = new XMLHttpRequest({ mozSystem: true });

    request.open('get', url, true);
    request.responseType = 'application/json';

    request.onerror = function(e) {
      var errorMessage = request.error;
      if(!errorMessage) {
        errorMessage = 'Error while searching';
      }
      showError(errorMessage);
    };

    request.onload = function() {

      definitionText.classList.remove('hidden');
      
      try {

        var response = JSON.parse(request.responseText);

        if (response.length == 0) {
            definitionText.innerHTML = '<h2>No results.</h2>';
        } else {
            for(var i = 0; i < response.length; i++) {
                var doc = response[i];
                var text = doc.location;
                var title = doc.zip;
                definitionText.innerHTML += '<h2>' + title + '</h2>' + text + '<br /><br />';
            }
        }




      } catch(e) {

        definitionText.innerHTML = '<p>' + translate('search_no_results') + '</p>';
        console.log('BOOM', e);

      }

    };

    request.send();

  }


  function showError(text) {
    errorMsg.innerHTML = text;
    errorMsg.classList.remove('hidden');
    definitionText.classList.add('hidden');
  }

};
